/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Martin Ester, Hans-Peter Kriegel, J\u00f6rg Sander, Xiaowei Xu", title="A Density-Based Algorithm for Discovering Clusters in Large Spatial Databases with Noise", booktitle="Proc. 2nd Int. Conf. on Knowledge Discovery and Data Mining (KDD '96)", url="http://www.aaai.org/Library/KDD/1996/kdd96-037.php", bibkey="DBLP:conf/kdd/EsterKSX96")
public class EpsilonNeighborPredicate<O>
implements NeighborPredicate<DoubleDBIDList> {
    protected double epsilon;
    protected DistanceFunction<? super O> distFunc;

    public EpsilonNeighborPredicate(double epsilon, DistanceFunction<? super O> distFunc) {
        this.epsilon = epsilon;
        this.distFunc = distFunc;
    }

    public Instance instantiate(Database database) {
        DistanceQuery<O> dq = QueryUtil.getDistanceQuery(database, this.distFunc, new Object[0]);
        RangeQuery<? super O> rq = database.getRangeQuery(dq, new Object[0]);
        return new Instance(this.epsilon, rq, dq.getRelation().getDBIDs());
    }

    @Override
    public SimpleTypeInformation<DoubleDBIDList> getOutputType() {
        return TypeUtil.NEIGHBORLIST;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.distFunc.getInputTypeRestriction();
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        protected double epsilon;
        protected DistanceFunction<O> distfun = null;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter epsilonP;
            super.makeOptions(config);
            ObjectParameter distanceP = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class);
            if (config.grab(distanceP)) {
                this.distfun = (DistanceFunction)distanceP.instantiateClass(config);
            }
            if (config.grab(epsilonP = (DoubleParameter)new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.epsilon = (Double)epsilonP.getValue();
            }
        }

        @Override
        protected EpsilonNeighborPredicate<O> makeInstance() {
            return new EpsilonNeighborPredicate<O>(this.epsilon, this.distfun);
        }
    }

    public static class Instance
    implements NeighborPredicate.Instance<DoubleDBIDList> {
        protected double epsilon;
        protected RangeQuery<?> rq;
        protected DBIDs ids;

        public Instance(double epsilon, RangeQuery<?> rq, DBIDs ids) {
            this.epsilon = epsilon;
            this.rq = rq;
            this.ids = ids;
        }

        @Override
        public DBIDs getIDs() {
            return this.ids;
        }

        @Override
        public DoubleDBIDList getNeighbors(DBIDRef reference) {
            return this.rq.getRangeForDBID(reference, this.epsilon);
        }

        @Override
        public DBIDIter iterDBIDs(DoubleDBIDList neighbors) {
            return neighbors.iter();
        }
    }
}

