/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.FourC;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.CorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.PreDeConNeighborPredicate;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="Christian B\u00f6hm, Karin Kailing, Peer Kr\u00f6ger, Arthur Zimek", title="Computing Clusters of Correlation Connected Objects", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD 2004)", url="https://doi.org/10.1145/1007568.1007620", bibkey="DBLP:conf/sigmod/BohmKKZ04")
public class FourCCorePredicate
implements CorePredicate<PreDeConNeighborPredicate.PreDeConModel> {
    protected FourC.Settings settings;

    public FourCCorePredicate(FourC.Settings settings) {
        this.settings = settings;
    }

    public Instance instantiate(Database database) {
        return new Instance(this.settings);
    }

    @Override
    public boolean acceptsType(SimpleTypeInformation<? extends PreDeConNeighborPredicate.PreDeConModel> type) {
        return type.getRestrictionClass().isAssignableFrom(PreDeConNeighborPredicate.PreDeConModel.class);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected FourC.Settings settings;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            this.settings = config.tryInstantiate(FourC.Settings.class);
        }

        @Override
        protected FourCCorePredicate makeInstance() {
            return new FourCCorePredicate(this.settings);
        }
    }

    public static class Instance
    implements CorePredicate.Instance<PreDeConNeighborPredicate.PreDeConModel> {
        protected FourC.Settings settings;

        public Instance(FourC.Settings settings) {
            this.settings = settings;
        }

        @Override
        public boolean isCorePoint(DBIDRef point, PreDeConNeighborPredicate.PreDeConModel model) {
            return model.pdim <= this.settings.lambda && model.ids.size() >= this.settings.minpts;
        }
    }
}

