/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.FourC;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.AbstractRangeQueryNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.PreDeConNeighborPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.StandardCovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.LimitEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="Christian B\u00f6hm, Karin Kailing, Peer Kr\u00f6ger, Arthur Zimek", title="Computing Clusters of Correlation Connected Objects", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data (SIGMOD 2004)", url="https://doi.org/10.1145/1007568.1007620", bibkey="DBLP:conf/sigmod/BohmKKZ04")
public class FourCNeighborPredicate<V extends NumberVector>
extends AbstractRangeQueryNeighborPredicate<V, PreDeConNeighborPredicate.PreDeConModel, PreDeConNeighborPredicate.PreDeConModel> {
    private static final Logging LOG = Logging.getLogger(FourCNeighborPredicate.class);
    private FourC.Settings settings;
    private MeanVariance mvSize = new MeanVariance();
    private MeanVariance mvSize2 = new MeanVariance();
    private MeanVariance mvCorDim = new MeanVariance();
    private PCARunner pca;
    private EigenPairFilter filter;

    public FourCNeighborPredicate(FourC.Settings settings) {
        super(settings.epsilon, EuclideanDistanceFunction.STATIC);
        this.settings = settings;
        this.pca = new PCARunner(new StandardCovarianceMatrixBuilder());
        this.filter = new LimitEigenPairFilter(settings.delta, settings.absolute);
    }

    public Instance instantiate(Database database) {
        Relation relation = database.getRelation(this.getInputTypeRestriction(), new Object[0]);
        DistanceQuery dq = database.getDistanceQuery(relation, this.distFunc, new Object[0]);
        RangeQuery rq = database.getRangeQuery(dq, new Object[0]);
        this.mvSize.reset();
        this.mvSize2.reset();
        this.mvCorDim.reset();
        DataStore<PreDeConNeighborPredicate.PreDeConModel> storage = this.preprocess(PreDeConNeighborPredicate.PreDeConModel.class, relation, rq);
        if (LOG.isVerbose()) {
            LOG.verbose("Average neighborhood size: " + this.mvSize.toString());
            LOG.verbose("Average correlation dimensionality: " + this.mvCorDim.toString());
            LOG.verbose("Average correlated neighborhood size: " + this.mvSize2.toString());
            int dim = RelationUtil.dimensionality(relation);
            if (this.mvSize.getMean() < (double)(5 * dim)) {
                LOG.verbose("The epsilon parameter may be chosen too small.");
            } else if (this.mvSize.getMean() > 0.5 * (double)relation.size()) {
                LOG.verbose("The epsilon parameter may be chosen too large.");
            } else if (this.mvSize2.getMean() < 10.0) {
                LOG.verbose("The epsilon parameter may be chosen too large, or delta too small.");
            } else if (this.mvSize2.getMean() < (double)this.settings.minpts) {
                LOG.verbose("The minPts parameter may be chosen too large.");
            } else {
                LOG.verbose("As a first guess, you can try minPts < " + (int)this.mvSize2.getMean() + ", but you will need to experiment with these parameters and epsilon.");
            }
        }
        return new Instance(dq.getRelation().getDBIDs(), storage);
    }

    @Override
    protected PreDeConNeighborPredicate.PreDeConModel computeLocalModel(DBIDRef id, DoubleDBIDList neighbors, Relation<V> relation) {
        this.mvSize.put(neighbors.size());
        PCAResult epairs = this.pca.processIds(neighbors, relation);
        int cordim = this.filter.filter(epairs.getEigenvalues());
        PCAFilteredResult pcares = new PCAFilteredResult(epairs.getEigenPairs(), cordim, this.settings.kappa, 1.0);
        double[][] m_hat = pcares.similarityMatrix();
        double[] obj = ((NumberVector)relation.get(id)).toArray();
        double sqeps = this.settings.epsilon * this.settings.epsilon;
        HashSetModifiableDBIDs survivors = DBIDUtil.newHashSet(neighbors.size());
        DoubleDBIDListIter iter = neighbors.iter();
        while (iter.valid()) {
            double[] diff = VMath.minusEquals(((NumberVector)relation.get(iter)).toArray(), obj);
            double dist = VMath.transposeTimesTimes(diff, m_hat, diff);
            if (dist <= sqeps) {
                survivors.add(iter);
            }
            iter.advance();
        }
        if (cordim <= this.settings.lambda) {
            this.mvSize2.put(survivors.size());
        }
        this.mvCorDim.put(cordim);
        return new PreDeConNeighborPredicate.PreDeConModel(cordim, survivors);
    }

    @Override
    Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    public SimpleTypeInformation<PreDeConNeighborPredicate.PreDeConModel> getOutputType() {
        return new SimpleTypeInformation<PreDeConNeighborPredicate.PreDeConModel>(PreDeConNeighborPredicate.PreDeConModel.class);
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        protected FourC.Settings settings;

        @Override
        protected void makeOptions(Parameterization config) {
            this.settings = config.tryInstantiate(FourC.Settings.class);
        }

        @Override
        protected FourCNeighborPredicate<O> makeInstance() {
            return new FourCNeighborPredicate(this.settings);
        }
    }

    public static class Instance
    extends AbstractRangeQueryNeighborPredicate.Instance<PreDeConNeighborPredicate.PreDeConModel, PreDeConNeighborPredicate.PreDeConModel> {
        public Instance(DBIDs ids, DataStore<PreDeConNeighborPredicate.PreDeConModel> storage) {
            super(ids, storage);
        }

        @Override
        public PreDeConNeighborPredicate.PreDeConModel getNeighbors(DBIDRef reference) {
            PreDeConNeighborPredicate.PreDeConModel asymmetric = (PreDeConNeighborPredicate.PreDeConModel)this.storage.get(reference);
            HashSetModifiableDBIDs ids = DBIDUtil.newHashSet(asymmetric.ids.size());
            DBIDIter neighbor = asymmetric.ids.iter();
            while (neighbor.valid()) {
                if (((PreDeConNeighborPredicate.PreDeConModel)this.storage.get((DBIDRef)neighbor)).ids.contains(reference)) {
                    ids.add(neighbor);
                }
                neighbor.advance();
            }
            return new PreDeConNeighborPredicate.PreDeConModel(asymmetric.pdim, ids);
        }

        @Override
        public DBIDIter iterDBIDs(PreDeConNeighborPredicate.PreDeConModel neighbors) {
            return neighbors.ids.iter();
        }
    }
}

