/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.CorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.EpsilonNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.MinPtsCorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.CoreObjectsModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.IntArrayList;

@Reference(authors="J\u00f6rg Sander, Martin Ester, Hans-Peter Kriegel, Xiaowei Xu", title="Density-Based Clustering in Spatial Databases: The Algorithm GDBSCAN and Its Applications", booktitle="Data Mining and Knowledge Discovery", url="https://doi.org/10.1023/A:1009745219419", bibkey="DBLP:journals/datamine/SanderEKX98")
public class GeneralizedDBSCAN
extends AbstractAlgorithm<Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(GeneralizedDBSCAN.class);
    protected NeighborPredicate<?> npred;
    protected CorePredicate<?> corepred;
    protected boolean coremodel = false;

    public GeneralizedDBSCAN(NeighborPredicate<?> npred, CorePredicate<?> corepred, boolean coremodel) {
        this.npred = npred;
        this.corepred = corepred;
        this.coremodel = coremodel;
        CorePredicate<?> cp = corepred;
        if (!cp.acceptsType(npred.getOutputType())) {
            throw new AbortException("Core predicate and neighbor predicate are not compatible.");
        }
    }

    @Override
    public Clustering<Model> run(Database database) {
        CorePredicate<?> cp = this.corepred;
        if (!cp.acceptsType(this.npred.getOutputType())) {
            throw new AbortException("Core predicate and neighbor predicate are not compatible.");
        }
        return new Instance(this.npred.instantiate(database), cp.instantiate(database), this.coremodel).run();
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.npred.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID NEIGHBORHOODPRED_ID = new OptionID("gdbscan.neighborhood", "Neighborhood predicate for Generalized DBSCAN");
        public static final OptionID COREPRED_ID = new OptionID("gdbscan.core", "Core point predicate for Generalized DBSCAN");
        public static final OptionID COREMODEL_ID = new OptionID("gdbscan.core-model", "Use a model that keeps track of core points. Needs more memory.");
        protected NeighborPredicate<?> npred = null;
        protected CorePredicate<?> corepred = null;
        protected boolean coremodel = false;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag coremodelOpt;
            CorePredicate<?> cp;
            ObjectParameter corepredOpt;
            ObjectParameter npredOpt = new ObjectParameter(NEIGHBORHOODPRED_ID, (Class<?>)NeighborPredicate.class, EpsilonNeighborPredicate.class);
            if (config.grab(npredOpt)) {
                this.npred = (NeighborPredicate)npredOpt.instantiateClass(config);
            }
            if (config.grab(corepredOpt = new ObjectParameter(COREPRED_ID, (Class<?>)CorePredicate.class, MinPtsCorePredicate.class))) {
                this.corepred = (CorePredicate)corepredOpt.instantiateClass(config);
            }
            if (this.npred != null && this.corepred != null && !(cp = this.corepred).acceptsType(this.npred.getOutputType())) {
                config.reportError(new WrongParameterValueException(corepredOpt, corepredOpt.getValueAsString(), "Neighbor predicate and core predicate are not compatible."));
            }
            if (config.grab(coremodelOpt = new Flag(COREMODEL_ID))) {
                this.coremodel = coremodelOpt.isTrue();
            }
        }

        @Override
        protected GeneralizedDBSCAN makeInstance() {
            return new GeneralizedDBSCAN(this.npred, this.corepred, this.coremodel);
        }
    }

    public static class Instance<T> {
        protected static final int UNPROCESSED = 0;
        protected static final int NOISE = 1;
        protected final NeighborPredicate.Instance<T> npred;
        protected final CorePredicate.Instance<? super T> corepred;
        protected boolean coremodel = false;

        public Instance(NeighborPredicate.Instance<T> npred, CorePredicate.Instance<? super T> corepred, boolean coremodel) {
            this.npred = npred;
            this.corepred = corepred;
            this.coremodel = coremodel;
        }

        public Clustering<Model> run() {
            int cid;
            DBIDs ids = this.npred.getIDs();
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Generalized DBSCAN Clustering", ids.size(), LOG) : null;
            IndefiniteProgress clusprogress = LOG.isVerbose() ? new IndefiniteProgress("Number of clusters found", LOG) : null;
            WritableIntegerDataStore clusterids = DataStoreUtil.makeIntegerStorage(ids, 1, 0);
            IntArrayList clustersizes = new IntArrayList();
            clustersizes.add(0);
            clustersizes.add(0);
            ArrayModifiableDBIDs activeSet = DBIDUtil.newArray();
            int clusterid = 2;
            DBIDIter id = ids.iter();
            while (id.valid()) {
                if (clusterids.intValue(id) == 0) {
                    T neighbors = this.npred.getNeighbors(id);
                    if (this.corepred.isCorePoint(id, neighbors)) {
                        LOG.incrementProcessed(clusprogress);
                        clustersizes.add(this.expandCluster(id, clusterid, clusterids, neighbors, activeSet, progress));
                        ++clusterid;
                    } else {
                        clusterids.putInt(id, 1);
                        clustersizes.set(1, clustersizes.getInt(1) + 1);
                    }
                    LOG.incrementProcessed(progress);
                }
                id.advance();
            }
            LOG.ensureCompleted(progress);
            LOG.setCompleted(clusprogress);
            ArrayModifiableDBIDs[] clusterlists = new ArrayModifiableDBIDs[clusterid];
            ArrayModifiableDBIDs[] corelists = this.coremodel ? new ArrayModifiableDBIDs[clusterid] : null;
            for (int i = 0; i < clustersizes.size(); ++i) {
                clusterlists[i] = DBIDUtil.newArray(clustersizes.getInt(i));
                if (corelists == null) continue;
                corelists[i] = DBIDUtil.newArray(clustersizes.getInt(i));
            }
            DBIDIter id2 = ids.iter();
            while (id2.valid()) {
                cid = clusterids.intValue(id2);
                int cluster = cid < 0 ? -cid : cid;
                clusterlists[cluster].add(id2);
                if (corelists != null && cid > 1) {
                    corelists[cluster].add(id2);
                }
                id2.advance();
            }
            clusterids.destroy();
            Clustering<Model> result = new Clustering<Model>("GDBSCAN", "gdbscan-clustering");
            for (cid = 1; cid < clusterlists.length; ++cid) {
                boolean isNoise = cid == 1;
                Model m = this.coremodel ? new CoreObjectsModel(corelists[cid]) : ClusterModel.CLUSTER;
                result.addToplevelCluster(new Cluster<ClusterModel>(clusterlists[cid], isNoise, (ClusterModel)m));
            }
            return result;
        }

        protected int expandCluster(DBIDRef seed, int clusterid, WritableIntegerDataStore clusterids, T neighbors, ArrayModifiableDBIDs activeSet, FiniteProgress progress) {
            assert (activeSet.size() == 0);
            int clustersize = 1 + this.processCorePoint(seed, neighbors, clusterid, clusterids, activeSet);
            DBIDVar id = DBIDUtil.newVar();
            while (!activeSet.isEmpty()) {
                activeSet.pop(id);
                T newneighbors = this.npred.getNeighbors(id);
                if (this.corepred.isCorePoint(id, newneighbors)) {
                    clustersize += this.processCorePoint(id, newneighbors, clusterid, clusterids, activeSet);
                }
                LOG.incrementProcessed(progress);
            }
            return clustersize;
        }

        protected int processCorePoint(DBIDRef seed, T newneighbors, int clusterid, WritableIntegerDataStore clusterids, ArrayModifiableDBIDs activeSet) {
            clusterids.putInt(seed, clusterid);
            int clustersize = 0;
            DBIDIter it = this.npred.iterDBIDs(newneighbors);
            while (it.valid()) {
                block5: {
                    block4: {
                        int oldassign;
                        block3: {
                            oldassign = clusterids.intValue(it);
                            if (oldassign != 0) break block3;
                            activeSet.add(it);
                            break block4;
                        }
                        if (oldassign != 1) break block5;
                    }
                    ++clustersize;
                    clusterids.putInt(it, -clusterid);
                }
                it.advance();
            }
            return clustersize;
        }
    }
}

