/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import net.jafama.FastMath;

@Title(value="LSDBC: Locally Scaled Density Based Clustering")
@Reference(authors="E. Bi\u00e7ici, D. Yuret", title="Locally Scaled Density Based Clustering", booktitle="Adaptive and Natural Computing Algorithms", url="https://doi.org/10.1007/978-3-540-71618-1_82", bibkey="DBLP:conf/icannga/BiciciY07")
@Priority(value=100)
public class LSDBC<O extends NumberVector>
extends AbstractDistanceBasedAlgorithm<O, Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static Logging LOG = Logging.getLogger(LSDBC.class);
    protected int k;
    protected double alpha;
    protected static int UNPROCESSED = 0;
    protected static int NOISE = 1;

    public LSDBC(DistanceFunction<? super O> distanceFunction, int k, double alpha) {
        super(distanceFunction);
        this.k = k + 1;
        this.alpha = alpha;
    }

    public Clustering<Model> run(Database database, Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("LSDBC", 3) : null;
        int dim = RelationUtil.dimensionality(relation);
        double factor = FastMath.pow(2.0, this.alpha / (double)dim);
        DBIDs ids = relation.getDBIDs();
        LOG.beginStep(stepprog, 1, "Materializing kNN neighborhoods");
        KNNQuery<O> knnq = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.k);
        LOG.beginStep(stepprog, 2, "Sorting by density");
        WritableDoubleDataStore dens = DataStoreUtil.makeDoubleStorage(ids, 3);
        this.fillDensities(knnq, ids, dens);
        ArrayModifiableDBIDs sids = DBIDUtil.newArray(ids);
        sids.sort(new DataStoreUtil.AscendingByDoubleDataStore(dens));
        LOG.beginStep(stepprog, 3, "Computing clusters");
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("LSDBC Clustering", ids.size(), LOG) : null;
        IndefiniteProgress clusprogress = LOG.isVerbose() ? new IndefiniteProgress("Number of clusters found", LOG) : null;
        WritableIntegerDataStore clusterids = DataStoreUtil.makeIntegerStorage(ids, 1, UNPROCESSED);
        IntArrayList clustersizes = new IntArrayList();
        clustersizes.add(0);
        clustersizes.add(0);
        int clusterid = NOISE + 1;
        DBIDArrayMIter id = sids.iter();
        while (id.valid()) {
            if (clusterids.intValue(id) == UNPROCESSED) {
                KNNList neighbors = knnq.getKNNForDBID(id, this.k);
                if (this.isLocalMaximum(neighbors.getKNNDistance(), neighbors, dens)) {
                    double mindens = factor * neighbors.getKNNDistance();
                    clusterids.putInt(id, clusterid);
                    clustersizes.add(this.expandCluster(clusterid, clusterids, knnq, neighbors, mindens, progress));
                    ++clusterid;
                    if (clusprogress != null) {
                        clusprogress.setProcessed(clusterid, LOG);
                    }
                } else {
                    clusterids.putInt(id, NOISE);
                    clustersizes.set(NOISE, clustersizes.getInt(NOISE) + 1);
                }
                LOG.incrementProcessed(progress);
            }
            id.advance();
        }
        LOG.ensureCompleted(progress);
        LOG.setCompleted(clusprogress);
        LOG.setCompleted(stepprog);
        ArrayList<ArrayModifiableDBIDs> clusterlists = new ArrayList<ArrayModifiableDBIDs>(clusterid);
        for (int i = 0; i < clustersizes.size(); ++i) {
            clusterlists.add(DBIDUtil.newArray(clustersizes.getInt(i)));
        }
        DBIDIter id2 = ids.iter();
        while (id2.valid()) {
            int cid = clusterids.intValue(id2);
            int cluster = Math.abs(cid);
            ((ArrayModifiableDBIDs)clusterlists.get(cluster)).add(id2);
            id2.advance();
        }
        clusterids.destroy();
        Clustering<Model> result = new Clustering<Model>("LSDBC", "lsdbc-clustering");
        for (int cid = NOISE; cid < clusterlists.size(); ++cid) {
            boolean isNoise = cid == NOISE;
            Cluster<ClusterModel> c = new Cluster<ClusterModel>((DBIDs)clusterlists.get(cid), isNoise, ClusterModel.CLUSTER);
            result.addToplevelCluster(c);
        }
        return result;
    }

    private boolean isLocalMaximum(double kdist, DBIDs neighbors, WritableDoubleDataStore kdists) {
        DBIDIter it = neighbors.iter();
        while (it.valid()) {
            if (kdists.doubleValue(it) < kdist) {
                return false;
            }
            it.advance();
        }
        return true;
    }

    protected int expandCluster(int clusterid, WritableIntegerDataStore clusterids, KNNQuery<O> knnq, DBIDs neighbors, double maxkdist, FiniteProgress progress) {
        int clustersize = 1;
        ArrayModifiableDBIDs activeSet = DBIDUtil.newArray();
        activeSet.addDBIDs(neighbors);
        DBIDVar id = DBIDUtil.newVar();
        while (!activeSet.isEmpty()) {
            activeSet.pop(id);
            int oldclus = clusterids.intValue(id);
            if (oldclus == NOISE) {
                ++clustersize;
                clusterids.putInt(id, -clusterid);
                continue;
            }
            if (oldclus != UNPROCESSED) continue;
            ++clustersize;
            KNNList newneighbors = knnq.getKNNForDBID(id, this.k);
            if (newneighbors.getKNNDistance() <= maxkdist) {
                activeSet.addDBIDs(newneighbors);
            }
            clusterids.putInt(id, clusterid);
            LOG.incrementProcessed(progress);
        }
        return clustersize;
    }

    private void fillDensities(KNNQuery<O> knnq, DBIDs ids, WritableDoubleDataStore dens) {
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Densities", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            KNNList neighbors = knnq.getKNNForDBID(iter, this.k);
            dens.putDouble(iter, neighbors.getKNNDistance());
            LOG.incrementProcessed(prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("lsdbc.k", "Neighborhood size (k)");
        public static final OptionID ALPHA_ID = new OptionID("lsdbc.alpha", "Density difference factor");
        protected int k;
        protected double alpha;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter alphaP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
            if (config.grab(alphaP = (DoubleParameter)new DoubleParameter(ALPHA_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.alpha = alphaP.doubleValue();
            }
        }

        @Override
        protected LSDBC<O> makeInstance() {
            return new LSDBC(this.distanceFunction, this.k, this.alpha);
        }
    }
}

