/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.CorePredicate;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="Martin Ester, Hans-Peter Kriegel, J\u00f6rg Sander, Xiaowei Xu", title="A Density-Based Algorithm for Discovering Clusters in Large Spatial Databases with Noise", booktitle="Proc. 2nd Int. Conf. on Knowledge Discovery and Data Mining (KDD '96)", url="http://www.aaai.org/Library/KDD/1996/kdd96-037.php", bibkey="DBLP:conf/kdd/EsterKSX96")
public class MinPtsCorePredicate
implements CorePredicate<DBIDs> {
    public static final Logging LOG = Logging.getLogger(MinPtsCorePredicate.class);
    protected int minpts;

    public MinPtsCorePredicate(int minpts) {
        this.minpts = minpts;
    }

    public Instance instantiate(Database database) {
        return new Instance(this.minpts);
    }

    @Override
    public boolean acceptsType(SimpleTypeInformation<? extends DBIDs> type) {
        return TypeUtil.DBIDS.isAssignableFromType(type) || TypeUtil.NEIGHBORLIST.isAssignableFromType(type);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected int minpts;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter minptsP = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(minptsP)) {
                this.minpts = minptsP.intValue();
                if (this.minpts <= 2) {
                    LOG.warning("DBSCAN with minPts <= 2 is equivalent to single-link clustering at a single height. Consider using larger values of minPts.");
                }
            }
        }

        @Override
        protected MinPtsCorePredicate makeInstance() {
            return new MinPtsCorePredicate(this.minpts);
        }
    }

    public static class Instance
    implements CorePredicate.Instance<DBIDs> {
        protected int minpts;

        public Instance(int minpts) {
            this.minpts = minpts;
        }

        @Override
        public boolean isCorePoint(DBIDRef point, DBIDs neighbors) {
            return neighbors.size() >= this.minpts;
        }
    }
}

