/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.AbstractRangeQueryNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.PreDeCon;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="Christian B\u00f6hm, Karin Kailing, Hans-Peter Kriegel, Peer Kr\u00f6ger", title="Density Connected Clustering with Local Subspace Preferences", booktitle="Proc. 4th IEEE Int. Conf. on Data Mining (ICDM'04)", url="https://doi.org/10.1109/ICDM.2004.10087", bibkey="DBLP:conf/icdm/BohmKKK04")
public class PreDeConNeighborPredicate<V extends NumberVector>
extends AbstractRangeQueryNeighborPredicate<V, PreDeConModel, PreDeConModel> {
    private static final Logging LOG = Logging.getLogger(PreDeConNeighborPredicate.class);
    private MeanVariance mvSize = new MeanVariance();
    private MeanVariance mvVar = new MeanVariance();
    private PreDeCon.Settings settings;

    public PreDeConNeighborPredicate(PreDeCon.Settings settings) {
        super(settings.epsilon * settings.epsilon, SquaredEuclideanDistanceFunction.STATIC);
        this.settings = settings;
    }

    public Instance instantiate(Database database) {
        DistanceQuery dq = QueryUtil.getDistanceQuery(database, this.distFunc, new Object[0]);
        Relation relation = dq.getRelation();
        RangeQuery rq = database.getRangeQuery(dq, new Object[0]);
        this.mvSize.reset();
        this.mvVar.reset();
        DataStore<PreDeConModel> storage = this.preprocess(PreDeConModel.class, relation, rq);
        if (LOG.isVerbose()) {
            LOG.verbose("Average neighborhood size: " + this.mvSize.toString());
            LOG.verbose("Average variance size: " + this.mvVar.toString());
            int dim = RelationUtil.dimensionality(relation);
            if (this.mvSize.getMean() < (double)(5 * dim)) {
                LOG.verbose("The epsilon parameter may be chosen too small.");
            } else if (this.mvSize.getMean() > 0.5 * (double)relation.size()) {
                LOG.verbose("The epsilon parameter may be chosen too large.");
            } else {
                LOG.verbose("As a first guess, you can try minPts < " + (int)this.mvSize.getMean() / dim + " and delta > " + this.mvVar.getMean() + ", but you will need to experiment with these parameters and epsilon.");
            }
        }
        return new Instance(dq.getRelation().getDBIDs(), storage);
    }

    @Override
    protected PreDeConModel computeLocalModel(DBIDRef id, DoubleDBIDList neighbors, Relation<V> relation) {
        int d;
        int referenceSetSize = neighbors.size();
        this.mvSize.put(referenceSetSize);
        if (referenceSetSize < 0) {
            LOG.warning("Empty reference set - should at least include the query point!");
            return new PreDeConModel(Integer.MAX_VALUE, DBIDUtil.EMPTYDBIDS);
        }
        NumberVector obj = (NumberVector)relation.get(id);
        int dim = obj.getDimensionality();
        double[] s = new double[dim];
        DoubleDBIDListIter neighbor = neighbors.iter();
        while (neighbor.valid()) {
            NumberVector o = (NumberVector)relation.get(neighbor);
            d = 0;
            while (d < dim) {
                double diff = obj.doubleValue(d) - o.doubleValue(d);
                int n = d++;
                s[n] = s[n] + diff * diff;
            }
            neighbor.advance();
        }
        for (int d2 = 0; d2 < dim; ++d2) {
            int n = d2;
            s[n] = s[n] / (double)referenceSetSize;
            this.mvVar.put(s[d2]);
        }
        double[] weights = new double[dim];
        int pdim = 0;
        for (d = 0; d < dim; ++d) {
            if (s[d] <= this.settings.delta) {
                weights[d] = this.settings.kappa;
                ++pdim;
                continue;
            }
            weights[d] = 1.0;
        }
        HashSetModifiableDBIDs survivors = DBIDUtil.newHashSet(referenceSetSize);
        DoubleDBIDListIter neighbor2 = neighbors.iter();
        while (neighbor2.valid()) {
            NumberVector o = (NumberVector)relation.get(neighbor2);
            double dev = 0.0;
            for (int d3 = 0; d3 < dim; ++d3) {
                double diff = obj.doubleValue(d3) - o.doubleValue(d3);
                dev += weights[d3] * diff * diff;
            }
            if (dev <= this.epsilon) {
                survivors.add(neighbor2);
            }
            neighbor2.advance();
        }
        return new PreDeConModel(pdim, survivors);
    }

    @Override
    Logging getLogger() {
        return LOG;
    }

    @Override
    public SimpleTypeInformation<PreDeConModel> getOutputType() {
        return new SimpleTypeInformation<PreDeConModel>(PreDeConModel.class);
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected PreDeCon.Settings settings;

        @Override
        protected void makeOptions(Parameterization config) {
            this.settings = config.tryInstantiate(PreDeCon.Settings.class);
        }

        @Override
        protected PreDeConNeighborPredicate<V> makeInstance() {
            return new PreDeConNeighborPredicate(this.settings);
        }
    }

    public static class Instance
    extends AbstractRangeQueryNeighborPredicate.Instance<PreDeConModel, PreDeConModel> {
        public Instance(DBIDs ids, DataStore<PreDeConModel> storage) {
            super(ids, storage);
        }

        @Override
        public PreDeConModel getNeighbors(DBIDRef reference) {
            PreDeConModel asymmetric = (PreDeConModel)this.storage.get(reference);
            HashSetModifiableDBIDs ids = DBIDUtil.newHashSet(asymmetric.ids.size());
            DBIDIter neighbor = asymmetric.ids.iter();
            while (neighbor.valid()) {
                if (((PreDeConModel)this.storage.get((DBIDRef)neighbor)).ids.contains(reference)) {
                    ids.add(neighbor);
                }
                neighbor.advance();
            }
            return new PreDeConModel(asymmetric.pdim, ids);
        }

        @Override
        public DBIDIter iterDBIDs(PreDeConModel neighbors) {
            return neighbors.ids.iter();
        }
    }

    public static class PreDeConModel {
        int pdim;
        SetDBIDs ids;

        public PreDeConModel(int pdim, SetDBIDs ids) {
            this.pdim = pdim;
            this.ids = ids;
        }
    }
}

