/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.parallel;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.CorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.EpsilonNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.MinPtsCorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.util.Assignment;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.util.Border;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.util.Core;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.util.MultiBorder;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.ParallelExecutor;
import de.lmu.ifi.dbs.elki.parallel.processor.Processor;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;

@Reference(prefix="closely related", authors="M. Patwary, D. Palsetia, A. Agrawal, W. K. Liao, F. Manne, A. Choudhary", title="A new scalable parallel DBSCAN algorithm using the disjoint-set data structure", booktitle="IEEE Int. Conf. for High Performance Computing, Networking, Storage and Analysis (SC)", url="https://doi.org/10.1109/SC.2012.9", bibkey="DBLP:conf/sc/PatwaryPALMC12")
public class ParallelGeneralizedDBSCAN
extends AbstractAlgorithm<Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(ParallelGeneralizedDBSCAN.class);
    protected NeighborPredicate<?> npred;
    protected CorePredicate<?> corepred;
    protected boolean coremodel = false;

    public ParallelGeneralizedDBSCAN(NeighborPredicate<?> npred, CorePredicate<?> corepred, boolean coremodel) {
        this.npred = npred;
        this.corepred = corepred;
        this.coremodel = coremodel;
        CorePredicate<?> cp = corepred;
        if (!cp.acceptsType(npred.getOutputType())) {
            throw new AbortException("Core predicate and neighbor predicate are not compatible.");
        }
    }

    @Override
    public Clustering<Model> run(Database database) {
        CorePredicate<?> cp = this.corepred;
        if (!cp.acceptsType(this.npred.getOutputType())) {
            throw new AbortException("Predicates are not compatible.");
        }
        return new Instance(database, this.npred, cp, this.coremodel).run();
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.npred.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID NEIGHBORHOODPRED_ID = new OptionID("gdbscan.neighborhood", "Neighborhood predicate for Generalized DBSCAN");
        public static final OptionID COREPRED_ID = new OptionID("gdbscan.core", "Core point predicate for Generalized DBSCAN");
        public static final OptionID COREMODEL_ID = new OptionID("gdbscan.core-model", "Use a model that keeps track of core points. Needs more memory.");
        protected NeighborPredicate<?> npred = null;
        protected CorePredicate<?> corepred = null;
        protected boolean coremodel = false;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag coremodelOpt;
            CorePredicate<?> cp;
            ObjectParameter corepredOpt;
            ObjectParameter npredOpt = new ObjectParameter(NEIGHBORHOODPRED_ID, (Class<?>)NeighborPredicate.class, EpsilonNeighborPredicate.class);
            if (config.grab(npredOpt)) {
                this.npred = (NeighborPredicate)npredOpt.instantiateClass(config);
            }
            if (config.grab(corepredOpt = new ObjectParameter(COREPRED_ID, (Class<?>)CorePredicate.class, MinPtsCorePredicate.class))) {
                this.corepred = (CorePredicate)corepredOpt.instantiateClass(config);
            }
            if (this.npred != null && this.corepred != null && !(cp = this.corepred).acceptsType(this.npred.getOutputType())) {
                config.reportError(new WrongParameterValueException(corepredOpt, corepredOpt.getValueAsString(), "Neighbor predicate and core predicate are not compatible."));
            }
            if (config.grab(coremodelOpt = new Flag(COREMODEL_ID))) {
                this.coremodel = coremodelOpt.isTrue();
            }
        }

        @Override
        protected ParallelGeneralizedDBSCAN makeInstance() {
            return new ParallelGeneralizedDBSCAN(this.npred, this.corepred, this.coremodel);
        }
    }

    public static class Instance<T>
    implements Processor {
        protected final NeighborPredicate.Instance<T> npred;
        protected final CorePredicate.Instance<? super T> corepred;
        protected boolean coremodel = false;
        private WritableDataStore<Assignment> clusterids;
        private Core[] cores;
        private Border[] borders;
        private int nextclus = 0;
        private Database database;
        private NeighborPredicate<? extends T> npreds;
        private FiniteProgress progress;

        public Instance(Database database, NeighborPredicate<T> npreds, CorePredicate<? super T> corepred, boolean coremodel) {
            this.npred = npreds.instantiate(database);
            this.database = database;
            this.npreds = npreds;
            this.corepred = corepred.instantiate(database);
            this.coremodel = coremodel;
            this.clusterids = DataStoreUtil.makeStorage(this.npred.getIDs(), 1, Assignment.class);
            this.cores = new Core[100];
            this.borders = new Border[100];
        }

        public Clustering<Model> run() {
            DBIDs ids = this.npred.getIDs();
            this.progress = LOG.isVerbose() ? new FiniteProgress("DBSCAN clustering", ids.size(), LOG) : null;
            ParallelExecutor.run(ids, this);
            LOG.ensureCompleted(this.progress);
            FiniteProgress pprog = LOG.isVerbose() ? new FiniteProgress("Building final result", ids.size(), LOG) : null;
            ModifiableDBIDs[] clusters = new ModifiableDBIDs[this.nextclus];
            ArrayModifiableDBIDs noise = DBIDUtil.newArray();
            DBIDIter it = ids.iter();
            while (it.valid()) {
                Assignment cids = (Assignment)this.clusterids.get(it);
                if (cids == null) {
                    noise.add(it);
                    LOG.incrementProcessed(pprog);
                } else {
                    if (cids instanceof MultiBorder) {
                        cids = ((MultiBorder)cids).getCore();
                    } else if (cids instanceof Border) {
                        cids = ((Border)cids).core;
                    }
                    assert (cids instanceof Core);
                    Core co = (Core)cids;
                    while (this.cores[co.num].num != co.num) {
                        co.num = this.cores[co.num].num;
                        co = this.cores[co.num];
                    }
                    ModifiableDBIDs clu = clusters[co.num];
                    if (clu == null) {
                        clu = clusters[co.num] = DBIDUtil.newArray();
                    }
                    clu.add(it);
                    LOG.incrementProcessed(pprog);
                }
                it.advance();
            }
            LOG.ensureCompleted(pprog);
            this.clusterids.destroy();
            Clustering<Model> result = new Clustering<Model>("DBSCAN Clustering", "dbscan-clustering");
            for (int i = 0; i < clusters.length; ++i) {
                if (clusters[i] == null) continue;
                result.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)clusters[i], ClusterModel.CLUSTER));
            }
            if (noise.size() > 0) {
                result.addToplevelCluster(new Cluster<ClusterModel>(noise, true, ClusterModel.CLUSTER));
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processNeighbors(DBIDRef id, T neighbors) {
            if (!this.corepred.isCorePoint(id, neighbors)) {
                LOG.incrementProcessed(this.progress);
                return;
            }
            Core core = null;
            DBIDIter it = this.npred.iterDBIDs(neighbors);
            while (it.valid()) {
                Assignment cand = (Assignment)this.clusterids.get(it);
                if (cand instanceof Core) {
                    core = (Core)cand;
                    break;
                }
                it.advance();
            }
            Instance instance = this;
            synchronized (instance) {
                if (core == null) {
                    if (this.nextclus == this.cores.length) {
                        this.cores = Arrays.copyOf(this.cores, this.cores.length + (this.cores.length >> 1));
                        this.borders = Arrays.copyOf(this.borders, this.cores.length);
                    }
                    core = this.cores[this.nextclus] = new Core(this.nextclus);
                    this.borders[this.nextclus] = new Border(core);
                    ++this.nextclus;
                }
                Border border = this.borders[core.num];
                this.clusterids.put(id, core);
                DBIDIter it2 = this.npred.iterDBIDs(neighbors);
                while (it2.valid()) {
                    Assignment oclus = (Assignment)this.clusterids.get(it2);
                    if (oclus != core) {
                        if (oclus == null) {
                            this.clusterids.put(it2, border);
                        } else if (oclus instanceof Core) {
                            core.mergeWith((Core)oclus);
                        } else if (oclus instanceof Border) {
                            Border oborder = (Border)oclus;
                            if (border.core.num != oborder.core.num) {
                                this.clusterids.put(it2, new MultiBorder(border, oborder));
                            }
                        } else {
                            assert (oclus instanceof MultiBorder);
                            this.clusterids.put(it2, ((MultiBorder)oclus).update(border));
                        }
                    }
                    it2.advance();
                }
            }
            LOG.incrementProcessed(this.progress);
        }

        @Override
        public Mapper instantiate(Executor executor) {
            NeighborPredicate.Instance<? extends T> inst = this.npreds.instantiate(this.database);
            return new Mapper(inst);
        }

        @Override
        public void cleanup(Processor.Instance inst) {
        }

        private class Mapper
        implements Processor.Instance {
            NeighborPredicate.Instance<? extends T> predicate;

            public Mapper(NeighborPredicate.Instance<? extends T> predicate) {
                this.predicate = predicate;
            }

            @Override
            public void map(DBIDRef id) {
                Instance.this.processNeighbors(id, this.predicate.getNeighbors(id));
            }
        }
    }
}

