/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.util;

import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.util.Assignment;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.util.Border;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.util.Core;
import java.util.Arrays;

public class MultiBorder
implements Assignment {
    public Border[] cs;

    public MultiBorder(Border i, Border j) {
        assert (i.core.num != j.core.num);
        this.cs = new Border[]{i, j};
    }

    public Assignment update(Border border) {
        Arrays.sort(this.cs);
        int j = 1;
        boolean found = this.cs[0].core == border.core;
        for (int i = 1; i < this.cs.length; ++i) {
            if (this.cs[i].core != this.cs[i - 1].core) {
                this.cs[j++] = this.cs[i];
            }
            found |= this.cs[i].core == border.core;
        }
        if (found) {
            if (j == 1) {
                Border r = this.cs[0];
                this.cs = null;
                return r;
            }
            if (j < this.cs.length) {
                this.cs = Arrays.copyOf(this.cs, j);
            }
            return this;
        }
        if (j + 1 != this.cs.length) {
            this.cs = Arrays.copyOf(this.cs, j + 1);
        }
        this.cs[j] = border;
        return this;
    }

    public Core getCore() {
        Core a = this.cs[0].core;
        for (int i = 1; i < this.cs.length; ++i) {
            Core v = this.cs[i].core;
            a = a.num > v.num ? a : v;
        }
        return a;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("MultiBorder[");
        for (Border b : this.cs) {
            buf.append(b.core.num).append(',');
        }
        buf.append(']');
        return buf.toString();
    }
}

