/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.MatrixParadigm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationBuilder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage.Linkage;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage.SingleLinkage;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage.WardLinkage;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@References(value={@Reference(authors="L. Kaufman, P. J. Rousseeuw", title="Agglomerative Nesting (Program AGNES)", booktitle="Finding Groups in Data: An Introduction to Cluster Analysis", url="https://doi.org/10.1002/9780470316801.ch5", bibkey="doi:10.1002/9780470316801.ch5"), @Reference(authors="P. H. Sneath", title="The application of computers to taxonomy", booktitle="Journal of general microbiology, 17(1)", url="https://doi.org/10.1099/00221287-17-1-201", bibkey="doi:10.1099/00221287-17-1-201"), @Reference(authors="R. M. Cormack", title="A Review of Classification", booktitle="Journal of the Royal Statistical Society. Series A, Vol. 134, No. 3", url="https://doi.org/10.2307/2344237", bibkey="doi:10.2307/2344237")})
@Alias(value={"HAC", "NaiveAgglomerativeHierarchicalClustering", "de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.NaiveAgglomerativeHierarchicalClustering"})
public class AGNES<O>
extends AbstractDistanceBasedAlgorithm<O, PointerHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(AGNES.class);
    Linkage linkage = WardLinkage.STATIC;

    public AGNES(DistanceFunction<? super O> distanceFunction, Linkage linkage) {
        super(distanceFunction);
        this.linkage = linkage;
    }

    public PointerHierarchyRepresentationResult run(Database db, Relation<O> relation) {
        if (SingleLinkage.class.isInstance(this.linkage)) {
            LOG.verbose("Notice: SLINK is a much faster algorithm for single-linkage clustering!");
        }
        DBIDs ids = relation.getDBIDs();
        int size = ids.size();
        DistanceQuery<O> dq = db.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        MatrixParadigm mat = new MatrixParadigm(ids);
        AGNES.initializeDistanceMatrix(mat, dq, this.linkage);
        PointerHierarchyRepresentationBuilder builder = new PointerHierarchyRepresentationBuilder(ids, dq.getDistanceFunction().isSquared());
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Agglomerative clustering", size - 1, LOG) : null;
        DBIDArrayIter ix = mat.ix;
        int end = size;
        for (int i = 1; i < size; ++i) {
            end = AGNES.shrinkActiveSet(ix, builder, end, this.findMerge(end, mat, builder));
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        return builder.complete();
    }

    protected static int shrinkActiveSet(DBIDArrayIter ix, PointerHierarchyRepresentationBuilder builder, int end, int x) {
        if (x == end - 1) {
            while (builder.isLinked(ix.seek(--end - 1))) {
            }
        }
        return end;
    }

    protected static void initializeDistanceMatrix(MatrixParadigm mat, DistanceQuery<?> dq, Linkage linkage) {
        DBIDArrayIter ix = mat.ix;
        DBIDArrayIter iy = mat.iy;
        double[] matrix = mat.matrix;
        boolean issquare = dq.getDistanceFunction().isSquared();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Distance matrix computation", matrix.length, LOG) : null;
        int pos = 0;
        ix.seek(0);
        while (ix.valid()) {
            int x = ix.getOffset();
            assert (pos == MatrixParadigm.triangleSize(x));
            iy.seek(0);
            while (iy.getOffset() < x) {
                matrix[pos++] = linkage.initial(dq.distance((DBIDRef)ix, (DBIDRef)iy), issquare);
                iy.advance();
            }
            if (prog != null) {
                prog.setProcessed(pos, LOG);
            }
            ix.advance();
        }
        if (prog != null) {
            prog.setProcessed(matrix.length, LOG);
        }
        LOG.ensureCompleted(prog);
    }

    protected int findMerge(int end, MatrixParadigm mat, PointerHierarchyRepresentationBuilder builder) {
        assert (end > 0);
        DBIDArrayIter ix = mat.ix;
        DBIDArrayIter iy = mat.iy;
        double[] matrix = mat.matrix;
        double mindist = Double.POSITIVE_INFINITY;
        int x = -1;
        int y = -1;
        int ox = 0;
        int xbase = 0;
        while (ox < end) {
            if (!builder.isLinked(ix.seek(ox))) {
                assert (xbase == MatrixParadigm.triangleSize(ox));
                for (int oy = 0; oy < ox; ++oy) {
                    double dist;
                    if (builder.isLinked(iy.seek(oy)) || !((dist = matrix[xbase + oy]) <= mindist)) continue;
                    mindist = dist;
                    x = ox;
                    y = oy;
                }
            }
            xbase += ox++;
        }
        assert (x >= 0 && y >= 0);
        assert (y < x);
        this.merge(end, mat, builder, mindist, x, y);
        return x;
    }

    protected void merge(int end, MatrixParadigm mat, PointerHierarchyRepresentationBuilder builder, double mindist, int x, int y) {
        DBIDArrayIter ix = mat.ix.seek(x);
        DBIDArrayIter iy = mat.iy.seek(y);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Merging: " + DBIDUtil.toString(ix) + " -> " + DBIDUtil.toString(iy) + " " + mindist);
        }
        assert (y < x);
        builder.add(ix, this.linkage.restore(mindist, this.getDistanceFunction().isSquared()), iy);
        int sizex = builder.getSize(ix);
        int sizey = builder.getSize(iy);
        builder.setSize(iy, sizex + sizey);
        this.updateMatrix(end, mat, builder, mindist, x, y, sizex, sizey);
    }

    protected void updateMatrix(int end, MatrixParadigm mat, PointerHierarchyRepresentationBuilder builder, double mindist, int x, int y, int sizex, int sizey) {
        int jb;
        int j;
        int xbase = MatrixParadigm.triangleSize(x);
        int ybase = MatrixParadigm.triangleSize(y);
        double[] scratch = mat.matrix;
        DBIDArrayIter ij = mat.ix;
        for (j = 0; j < y; ++j) {
            if (builder.isLinked(ij.seek(j))) continue;
            assert (j < y);
            int yb = ybase + j;
            scratch[yb] = this.linkage.combine(sizex, scratch[xbase + j], sizey, scratch[yb], builder.getSize(ij), mindist);
        }
        int jbase = MatrixParadigm.triangleSize(++j);
        while (j < x) {
            if (!builder.isLinked(ij.seek(j))) {
                jb = jbase + y;
                scratch[jb] = this.linkage.combine(sizex, scratch[xbase + j], sizey, scratch[jb], builder.getSize(ij), mindist);
            }
            jbase += j++;
        }
        jbase += j++;
        while (j < end) {
            if (!builder.isLinked(ij.seek(j))) {
                jb = jbase + y;
                scratch[jb] = this.linkage.combine(sizex, scratch[jbase + x], sizey, scratch[jb], builder.getSize(ij), mindist);
            }
            jbase += j++;
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID LINKAGE_ID = new OptionID("hierarchical.linkage", "Linkage method to use (e.g. Ward, Single-Link)");
        protected Linkage linkage;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter distanceFunctionP = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, SquaredEuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distanceFunction = (DistanceFunction)distanceFunctionP.instantiateClass(config);
            }
            ObjectParameter linkageP = new ObjectParameter(LINKAGE_ID, Linkage.class);
            linkageP.setDefaultValue(WardLinkage.class);
            if (config.grab(linkageP)) {
                this.linkage = (Linkage)linkageP.instantiateClass(config);
            }
        }

        @Override
        protected AGNES<O> makeInstance() {
            return new AGNES(this.distanceFunction, this.linkage);
        }
    }
}

