/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.geometry.PrimsMinimumSpanningTree;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleLongHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="R. J. G. B. Campello, D. Moulavi, J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conf. Advances in Knowledge Discovery and Data Mining (PAKDD)", url="https://doi.org/10.1007/978-3-642-37456-2_14", bibkey="DBLP:conf/pakdd/CampelloMS13")
public abstract class AbstractHDBSCAN<O, R extends Result>
extends AbstractDistanceBasedAlgorithm<O, R> {
    protected final int minPts;

    public AbstractHDBSCAN(DistanceFunction<? super O> distanceFunction, int minPts) {
        super(distanceFunction);
        this.minPts = minPts;
    }

    protected WritableDoubleDataStore computeCoreDists(DBIDs ids, KNNQuery<O> knnQ, int minPts) {
        Logging LOG = this.getLogger();
        WritableDoubleDataStore coredists = DataStoreUtil.makeDoubleStorage(ids, 30);
        FiniteProgress cprog = LOG.isVerbose() ? new FiniteProgress("Computing core sizes", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            coredists.put((DBIDRef)iter, knnQ.getKNNForDBID(iter, minPts).getKNNDistance());
            LOG.incrementProcessed(cprog);
            iter.advance();
        }
        LOG.ensureCompleted(cprog);
        return coredists;
    }

    protected void convertToPointerRepresentation(ArrayDBIDs ids, DoubleLongHeap heap, WritableDBIDDataStore pi, WritableDoubleDataStore lambda) {
        FiniteProgress pprog;
        Logging LOG = this.getLogger();
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            pi.put((DBIDRef)iter, iter);
            iter.advance();
        }
        DBIDVar p = DBIDUtil.newVar();
        DBIDVar q = DBIDUtil.newVar();
        DBIDVar n = DBIDUtil.newVar();
        FiniteProgress finiteProgress = pprog = LOG.isVerbose() ? new FiniteProgress("Converting MST to pointer representation", heap.size(), LOG) : null;
        while (!heap.isEmpty()) {
            double dist = heap.peekKey();
            long pair = heap.peekValue();
            int i = (int)(pair >>> 31);
            int j = (int)(pair & Integer.MAX_VALUE);
            ids.assignVar(i, p);
            while (!DBIDUtil.equal(p, pi.assignVar(p, n))) {
                p.set(n);
            }
            ids.assignVar(j, q);
            while (!DBIDUtil.equal(q, pi.assignVar(q, n))) {
                q.set(n);
            }
            int c = DBIDUtil.compare(p, q);
            if (c < 0) {
                pi.put((DBIDRef)p, q);
                lambda.put((DBIDRef)p, dist);
            } else {
                assert (c != 0) : "This should never happen!";
                pi.put((DBIDRef)q, p);
                lambda.put((DBIDRef)q, dist);
            }
            heap.poll();
            LOG.incrementProcessed(pprog);
        }
        LOG.ensureCompleted(pprog);
        DBIDArrayIter iter2 = ids.iter();
        while (iter2.valid()) {
            double d = lambda.doubleValue(iter2);
            pi.assignVar(iter2, p);
            q.set(p);
            while (d >= lambda.doubleValue(q) && !DBIDUtil.equal(q, pi.assignVar(q, n))) {
                q.set(n);
            }
            if (!DBIDUtil.equal(p, q)) {
                if (LOG.isDebuggingFinest()) {
                    LOG.finest("Correcting parent: " + p + " -> " + q);
                }
                pi.put((DBIDRef)iter2, q);
            }
            iter2.advance();
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    public static abstract class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID MIN_PTS_ID = new OptionID("hdbscan.minPts", "Threshold for minimum number of points in the epsilon-neighborhood of a point (including this point).");
        protected int minPts;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter minptsP = (IntParameter)new IntParameter(MIN_PTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(minptsP)) {
                this.minPts = (Integer)minptsP.getValue();
            }
        }
    }

    public static class HeapMSTCollector
    implements PrimsMinimumSpanningTree.Collector {
        private DoubleLongHeap heap;
        private FiniteProgress prog;
        private Logging log;

        public HeapMSTCollector(DoubleLongHeap heap, FiniteProgress prog, Logging log) {
            this.heap = heap;
            this.prog = prog;
            this.log = log;
        }

        @Override
        public void addEdge(double length, int i, int j) {
            this.heap.add(length, (long)i << 31 | (long)j);
            if (this.log != null && this.prog != null) {
                this.log.incrementProcessed(this.prog);
            }
        }
    }

    protected static class HDBSCANAdapter
    implements PrimsMinimumSpanningTree.Adapter<ArrayDBIDs> {
        private ArrayDBIDs ids;
        private DBIDArrayIter q;
        private DBIDArrayIter p;
        private DoubleDataStore coredists;
        private DistanceQuery<?> distq;

        public HDBSCANAdapter(ArrayDBIDs ids, DoubleDataStore coredists, DistanceQuery<?> distq) {
            this.ids = ids;
            this.q = ids.iter();
            this.p = ids.iter();
            this.coredists = coredists;
            this.distq = distq;
        }

        @Override
        public double distance(ArrayDBIDs data, int ip, int iq) {
            this.p.seek(ip);
            this.q.seek(iq);
            double coreP = this.coredists.doubleValue(this.p);
            double coreQ = this.coredists.doubleValue(this.q);
            return MathUtil.max(coreP, coreQ, this.distq.distance((DBIDRef)this.p, (DBIDRef)this.q));
        }

        @Override
        public int size(ArrayDBIDs data) {
            assert (data == this.ids);
            return this.ids.size();
        }
    }
}

