/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.AGNES;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.MatrixParadigm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationBuilder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage.Linkage;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage.SingleLinkage;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage.WardLinkage;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;

@Reference(authors="M. R. Anderberg", title="Hierarchical Clustering Methods", booktitle="Cluster Analysis for Applications", bibkey="books/academic/Anderberg73/Ch6")
@Priority(value=200)
public class AnderbergHierarchicalClustering<O>
extends AbstractDistanceBasedAlgorithm<O, PointerHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(AnderbergHierarchicalClustering.class);
    Linkage linkage = WardLinkage.STATIC;

    public AnderbergHierarchicalClustering(DistanceFunction<? super O> distanceFunction, Linkage linkage) {
        super(distanceFunction);
        this.linkage = linkage;
    }

    public PointerHierarchyRepresentationResult run(Database db, Relation<O> relation) {
        if (SingleLinkage.class.isInstance(this.linkage)) {
            LOG.verbose("Notice: SLINK is a much faster algorithm for single-linkage clustering!");
        }
        DistanceQuery<O> dq = db.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        DBIDs ids = relation.getDBIDs();
        MatrixParadigm mat = new MatrixParadigm(ids);
        int size = ids.size();
        AGNES.initializeDistanceMatrix(mat, dq, this.linkage);
        double[] bestd = new double[size];
        int[] besti = new int[size];
        AnderbergHierarchicalClustering.initializeNNCache(mat.matrix, bestd, besti);
        PointerHierarchyRepresentationBuilder builder = new PointerHierarchyRepresentationBuilder(ids, dq.getDistanceFunction().isSquared());
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Agglomerative clustering", size - 1, LOG) : null;
        DBIDArrayIter ix = mat.ix;
        int end = size;
        for (int i = 1; i < size; ++i) {
            end = AGNES.shrinkActiveSet(ix, builder, end, this.findMerge(end, mat, bestd, besti, builder));
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        return builder.complete();
    }

    private static void initializeNNCache(double[] scratch, double[] bestd, int[] besti) {
        int size = bestd.length;
        Arrays.fill(bestd, Double.POSITIVE_INFINITY);
        Arrays.fill(besti, -1);
        int p = 0;
        for (int x = 0; x < size; ++x) {
            assert (p == MatrixParadigm.triangleSize(x));
            double bestdx = Double.POSITIVE_INFINITY;
            int bestix = -1;
            int y = 0;
            while (y < x) {
                double v = scratch[p];
                if (v < bestd[y]) {
                    bestd[y] = v;
                    besti[y] = x;
                }
                if (v < bestdx) {
                    bestdx = v;
                    bestix = y;
                }
                ++y;
                ++p;
            }
            bestd[x] = bestdx;
            besti[x] = bestix;
        }
    }

    protected int findMerge(int size, MatrixParadigm mat, double[] bestd, int[] besti, PointerHierarchyRepresentationBuilder builder) {
        double mindist = Double.POSITIVE_INFINITY;
        int x = -1;
        int y = -1;
        for (int cx = 0; cx < size; ++cx) {
            double dist;
            int cy = besti[cx];
            if (cy < 0 || !((dist = bestd[cx]) <= mindist)) continue;
            mindist = dist;
            x = cx;
            y = cy;
        }
        assert (x >= 0 && y >= 0);
        assert (y < x);
        this.merge(size, mat, bestd, besti, builder, mindist, x, y);
        return x;
    }

    protected void merge(int size, MatrixParadigm mat, double[] bestd, int[] besti, PointerHierarchyRepresentationBuilder builder, double mindist, int x, int y) {
        DBIDArrayIter ix = mat.ix.seek(x);
        DBIDArrayIter iy = mat.iy.seek(y);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Merging: " + DBIDUtil.toString(ix) + " -> " + DBIDUtil.toString(iy) + " " + mindist);
        }
        assert (y < x);
        builder.add(ix, this.linkage.restore(mindist, this.getDistanceFunction().isSquared()), iy);
        int sizex = builder.getSize(ix);
        int sizey = builder.getSize(iy);
        builder.setSize(iy, sizex + sizey);
        besti[x] = -1;
        this.updateMatrix(size, mat.matrix, iy, bestd, besti, builder, mindist, x, y, sizex, sizey);
        if (besti[y] == x) {
            this.findBest(size, mat.matrix, bestd, besti, y);
        }
    }

    protected void updateMatrix(int size, double[] scratch, DBIDArrayIter ij, double[] bestd, int[] besti, PointerHierarchyRepresentationBuilder builder, double mindist, int x, int y, int sizex, int sizey) {
        double d;
        int sizej;
        int j;
        int xbase = MatrixParadigm.triangleSize(x);
        int ybase = MatrixParadigm.triangleSize(y);
        for (j = 0; j < y; ++j) {
            if (builder.isLinked(ij.seek(j))) continue;
            int sizej2 = builder.getSize(ij);
            int yb = ybase + j;
            double d2 = scratch[yb] = this.linkage.combine(sizex, scratch[xbase + j], sizey, scratch[yb], sizej2, mindist);
            this.updateCache(size, scratch, bestd, besti, x, y, j, d2);
        }
        int jbase = MatrixParadigm.triangleSize(++j);
        while (j < x) {
            if (!builder.isLinked(ij.seek(j))) {
                sizej = builder.getSize(ij);
                int jb = jbase + y;
                d = scratch[jb] = this.linkage.combine(sizex, scratch[xbase + j], sizey, scratch[jb], sizej, mindist);
                this.updateCache(size, scratch, bestd, besti, x, y, j, d);
            }
            jbase += j++;
        }
        jbase += j++;
        while (j < size) {
            if (!builder.isLinked(ij.seek(j))) {
                sizej = builder.getSize(ij);
                int jb = jbase + y;
                d = scratch[jb] = this.linkage.combine(sizex, scratch[jbase + x], sizey, scratch[jb], sizej, mindist);
                this.updateCache(size, scratch, bestd, besti, x, y, j, d);
            }
            jbase += j++;
        }
    }

    private void updateCache(int size, double[] scratch, double[] bestd, int[] besti, int x, int y, int j, double d) {
        if (d <= bestd[j]) {
            bestd[j] = d;
            besti[j] = y;
            return;
        }
        if (besti[j] == x || besti[j] == y) {
            this.findBest(size, scratch, bestd, besti, j);
        }
    }

    protected void findBest(int size, double[] scratch, double[] bestd, int[] besti, int j) {
        double dist;
        int jbase = MatrixParadigm.triangleSize(j);
        double bestdj = Double.POSITIVE_INFINITY;
        int bestij = -1;
        int i = 0;
        int o = jbase;
        while (i < j) {
            if (besti[i] >= 0 && (dist = scratch[o]) <= bestdj) {
                bestdj = dist;
                bestij = i;
            }
            ++i;
            ++o;
        }
        o = jbase + j + j;
        for (i = j + 1; i < size; ++i) {
            if (besti[i] >= 0 && (dist = scratch[o]) <= bestdj) {
                bestdj = dist;
                bestij = i;
            }
            o += i;
        }
        bestd[j] = bestdj;
        besti[j] = bestij;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        protected Linkage linkage;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter distanceFunctionP = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, SquaredEuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distanceFunction = (DistanceFunction)distanceFunctionP.instantiateClass(config);
            }
            ObjectParameter linkageP = new ObjectParameter(AGNES.Parameterizer.LINKAGE_ID, Linkage.class);
            linkageP.setDefaultValue(WardLinkage.class);
            if (config.grab(linkageP)) {
                this.linkage = (Linkage)linkageP.instantiateClass(config);
            }
        }

        @Override
        protected AnderbergHierarchicalClustering<O> makeInstance() {
            return new AnderbergHierarchicalClustering(this.distanceFunction, this.linkage);
        }
    }
}

