/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.SLINK;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="D. Defays", title="An Efficient Algorithm for the Complete Link Cluster Method", booktitle="The Computer Journal 20.4", url="https://doi.org/10.1093/comjnl/20.4.364", bibkey="DBLP:journals/cj/Defays77")
@Alias(value={"Defays"})
public class CLINK<O>
extends SLINK<O> {
    private static final Logging LOG = Logging.getLogger(CLINK.class);

    public CLINK(DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
    }

    @Override
    protected void process(DBIDRef id, ArrayDBIDs ids, DBIDArrayIter it, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, WritableDoubleDataStore m) {
        this.clinkstep3(id, it, n, pi, lambda, m);
        this.clinkstep4567(id, ids, it, n, pi, lambda, m);
        this.clinkstep8(id, it, n, pi, lambda, m);
    }

    private void clinkstep3(DBIDRef id, DBIDArrayIter i, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, WritableDoubleDataStore m) {
        DBIDVar p_i = DBIDUtil.newVar();
        i.seek(0);
        while (i.getOffset() < n) {
            double m_i;
            double l_i = lambda.doubleValue(i);
            if (l_i < (m_i = m.doubleValue(i))) {
                p_i.from(pi, i);
                double mp_i = m.doubleValue(p_i);
                if (mp_i < m_i) {
                    m.putDouble(p_i, m_i);
                }
                m.putDouble(i, Double.POSITIVE_INFINITY);
            }
            i.advance();
        }
    }

    private void clinkstep4567(DBIDRef id, ArrayDBIDs ids, DBIDArrayIter it, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, WritableDoubleDataStore m) {
        DBIDArrayIter a = ids.iter().seek(n - 1);
        DBIDVar p_i = DBIDUtil.newVar();
        it.seek(n - 1);
        while (it.valid()) {
            double mp_i;
            double l_i = lambda.doubleValue(it);
            if (l_i >= (mp_i = m.doubleValue(p_i.from(pi, it)))) {
                if (m.doubleValue(it) < m.doubleValue(a)) {
                    a.seek(it.getOffset());
                }
            } else {
                m.putDouble(it, Double.POSITIVE_INFINITY);
            }
            it.retract();
        }
        DBIDVar b = DBIDUtil.newVar().from(pi, a);
        double c = lambda.doubleValue(a);
        pi.putDBID(a, id);
        lambda.putDouble(a, m.doubleValue(a));
        if (a.getOffset() < n - 1) {
            DBIDVar last = DBIDUtil.newVar(it.seek(n - 1));
            DBIDVar d = DBIDUtil.newVar();
            while (!DBIDUtil.equal(b, id)) {
                if (DBIDUtil.equal(b, last)) {
                    pi.putDBID(b, id);
                    lambda.putDouble(b, c);
                    break;
                }
                d.from(pi, b);
                pi.putDBID(b, id);
                c = lambda.putDouble(b, c);
                b.set(d);
            }
        }
    }

    private void clinkstep8(DBIDRef id, DBIDArrayIter it, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, WritableDoubleDataStore m) {
        DBIDVar p_i = DBIDUtil.newVar();
        DBIDVar pp_i = DBIDUtil.newVar();
        it.seek(0);
        while (it.getOffset() < n) {
            p_i.from(pi, it);
            pp_i.from(pi, p_i);
            if (DBIDUtil.equal(pp_i, id) && lambda.doubleValue(it) >= lambda.doubleValue(p_i)) {
                pi.putDBID(it, id);
            }
            it.advance();
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        @Override
        protected CLINK<O> makeInstance() {
            return new CLINK(this.distanceFunction);
        }
    }
}

