/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.AbstractHDBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerDensityHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.geometry.PrimsMinimumSpanningTree;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleLongMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="HDBSCAN: Hierarchical Density-Based Spatial Clustering of Applications with Noise")
@Description(value="Density-Based Clustering Based on Hierarchical Density Estimates")
@Reference(authors="R. J. G. B. Campello, D. Moulavi, J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conf. Advances in Knowledge Discovery and Data Mining (PAKDD)", url="https://doi.org/10.1007/978-3-642-37456-2_14", bibkey="DBLP:conf/pakdd/CampelloMS13")
public class HDBSCANLinearMemory<O>
extends AbstractHDBSCAN<O, PointerDensityHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(HDBSCANLinearMemory.class);

    public HDBSCANLinearMemory(DistanceFunction<? super O> distanceFunction, int minPts) {
        super(distanceFunction, minPts);
    }

    public PointerDensityHierarchyRepresentationResult run(Database db, Relation<O> relation) {
        DistanceQuery<O> distQ = db.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> knnQ = db.getKNNQuery(distQ, this.minPts);
        ArrayDBIDs ids = DBIDUtil.ensureArray(relation.getDBIDs());
        WritableDoubleDataStore coredists = this.computeCoreDists(ids, knnQ, this.minPts);
        int numedges = ids.size() - 1;
        DoubleLongMinHeap heap = new DoubleLongMinHeap(numedges);
        FiniteProgress mprog = LOG.isVerbose() ? new FiniteProgress("Computing minimum spanning tree (n-1 edges)", numedges, LOG) : null;
        PrimsMinimumSpanningTree.processDense(ids, new AbstractHDBSCAN.HDBSCANAdapter(ids, coredists, distQ), new AbstractHDBSCAN.HeapMSTCollector(heap, mprog, LOG));
        LOG.ensureCompleted(mprog);
        WritableDBIDDataStore pi = DataStoreUtil.makeDBIDStorage(ids, 6);
        WritableDoubleDataStore lambda = DataStoreUtil.makeDoubleStorage(ids, 6, Double.POSITIVE_INFINITY);
        this.convertToPointerRepresentation(ids, heap, pi, lambda);
        return new PointerDensityHierarchyRepresentationResult((DBIDs)ids, (DBIDDataStore)pi, (DoubleDataStore)lambda, distQ.getDistanceFunction().isSquared(), coredists);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractHDBSCAN.Parameterizer<O> {
        @Override
        protected HDBSCANLinearMemory<O> makeInstance() {
            return new HDBSCANLinearMemory(this.distanceFunction, this.minPts);
        }
    }
}

