/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

public class MatrixParadigm {
    public final DBIDArrayIter ix;
    public final DBIDArrayIter iy;
    public final double[] matrix;
    public final int size;

    public MatrixParadigm(DBIDs ids) {
        this.size = ids.size();
        if (this.size > 65536) {
            throw new AbortException("This implementation does not scale to data sets larger than 65536 instances (~16 GB RAM), at which point the Java maximum array size is reached.");
        }
        ArrayDBIDs aids = DBIDUtil.ensureArray(ids);
        this.ix = aids.iter();
        this.iy = aids.iter();
        this.matrix = new double[MatrixParadigm.triangleSize(this.size)];
    }

    public static int triangleSize(int x) {
        return x * (x - 1) >>> 1;
    }

    public double get(int x, int y) {
        return x == y ? 0.0 : (x < y ? this.matrix[MatrixParadigm.triangleSize(y) + x] : this.matrix[MatrixParadigm.triangleSize(x) + y]);
    }

    public MatrixParadigm initializeWithDistances(DistanceQuery<?> dq) {
        DBIDArrayIter ix = this.ix;
        DBIDArrayIter iy = this.iy;
        double[] matrix = this.matrix;
        int pos = 0;
        ix.seek(0);
        while (ix.valid()) {
            int x = ix.getOffset();
            assert (pos == MatrixParadigm.triangleSize(x));
            iy.seek(0);
            while (iy.getOffset() < x) {
                matrix[pos++] = dq.distance((DBIDRef)ix, (DBIDRef)iy);
                iy.advance();
            }
            ix.advance();
        }
        return this;
    }
}

