/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.AGNES;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.MatrixParadigm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationBuilder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerPrototypeHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

@References(value={@Reference(authors="S. I. Ao, K. Yip, M. Ng, D. Cheung, P.-Y. Fong, I. Melhado, P. C. Sham", title="CLUSTAG: hierarchical clustering and graph methods for selecting tag SNPs", booktitle="Bioinformatics, 21 (8)", url="https://doi.org/10.1093/bioinformatics/bti201", bibkey="DBLP:journals/bioinformatics/AoYNCFMS05"), @Reference(authors="J. Bien, R. Tibshirani", title="Hierarchical Clustering with Prototypes via Minimax Linkage", booktitle="Journal of the American Statistical Association 106(495)", url="https://doi.org/10.1198/jasa.2011.tm10183", bibkey="doi:10.1198/jasa.2011.tm10183")})
public class MiniMax<O>
extends AbstractDistanceBasedAlgorithm<O, PointerPrototypeHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(MiniMax.class);

    public MiniMax(DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
    }

    public PointerPrototypeHierarchyRepresentationResult run(Database db, Relation<O> relation) {
        DistanceQuery<O> dq = DatabaseUtil.precomputedDistanceQuery(db, relation, this.getDistanceFunction(), LOG);
        DBIDs ids = relation.getDBIDs();
        int size = ids.size();
        PointerHierarchyRepresentationBuilder builder = new PointerHierarchyRepresentationBuilder(ids, dq.getDistanceFunction().isSquared());
        Int2ObjectOpenHashMap<ModifiableDBIDs> clusters = new Int2ObjectOpenHashMap<ModifiableDBIDs>(size);
        MatrixParadigm mat = new MatrixParadigm(ids);
        ArrayModifiableDBIDs prots = DBIDUtil.newArray(MatrixParadigm.triangleSize(size));
        MiniMax.initializeMatrices(mat, prots, dq);
        DBIDArrayMIter protiter = prots.iter();
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("MiniMax clustering", size - 1, LOG) : null;
        DBIDArrayIter ix = mat.ix;
        int end = size;
        for (int i = 1; i < size; ++i) {
            end = AGNES.shrinkActiveSet(ix, builder, end, MiniMax.findMerge(end, mat, protiter, builder, clusters, dq));
            LOG.incrementProcessed(progress);
        }
        LOG.ensureCompleted(progress);
        return (PointerPrototypeHierarchyRepresentationResult)builder.complete();
    }

    protected static <O> void initializeMatrices(MatrixParadigm mat, ArrayModifiableDBIDs prots, DistanceQuery<O> dq) {
        DBIDArrayIter ix = mat.ix;
        DBIDArrayIter iy = mat.iy;
        double[] distances = mat.matrix;
        int pos = 0;
        ix.seek(0);
        while (ix.valid()) {
            iy.seek(0);
            while (iy.getOffset() < ix.getOffset()) {
                distances[pos] = dq.distance((DBIDRef)ix, (DBIDRef)iy);
                prots.add(iy);
                ++pos;
                iy.advance();
            }
            ix.advance();
        }
        assert (prots.size() == pos);
    }

    protected static int findMerge(int end, MatrixParadigm mat, DBIDArrayMIter prots, PointerHierarchyRepresentationBuilder builder, Int2ObjectOpenHashMap<ModifiableDBIDs> clusters, DistanceQuery<?> dq) {
        DBIDArrayIter ix = mat.ix;
        DBIDArrayIter iy = mat.iy;
        double[] distances = mat.matrix;
        double mindist = Double.POSITIVE_INFINITY;
        int x = -1;
        int y = -1;
        for (int dx = 0; dx < end; ++dx) {
            if (builder.isLinked(ix.seek(dx))) continue;
            int xoffset = MatrixParadigm.triangleSize(dx);
            for (int dy = 0; dy < dx; ++dy) {
                double dist;
                if (builder.isLinked(iy.seek(dy)) || !((dist = distances[xoffset + dy]) < mindist)) continue;
                mindist = dist;
                x = dx;
                y = dy;
            }
        }
        assert (y < x);
        MiniMax.merge(end, mat, prots, builder, clusters, dq, x, y);
        return x;
    }

    protected static void merge(int size, MatrixParadigm mat, DBIDArrayMIter prots, PointerHierarchyRepresentationBuilder builder, Int2ObjectOpenHashMap<ModifiableDBIDs> clusters, DistanceQuery<?> dq, int x, int y) {
        assert (y < x);
        DBIDArrayIter ix = mat.ix.seek(x);
        DBIDArrayIter iy = mat.iy.seek(y);
        double[] distances = mat.matrix;
        int offset = MatrixParadigm.triangleSize(x) + y;
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Merging: " + DBIDUtil.toString(ix) + " -> " + DBIDUtil.toString(iy) + " " + distances[offset]);
        }
        ModifiableDBIDs cx = clusters.get(x);
        ModifiableDBIDs cy = clusters.get(y);
        if (cy == null) {
            cy = DBIDUtil.newHashSet();
            cy.add(iy);
        }
        if (cx == null) {
            cy.add(ix);
        } else {
            cy.addDBIDs(cx);
            clusters.remove(x);
        }
        clusters.put(y, cy);
        builder.add(ix, distances[offset], iy, prots.seek(offset));
        MiniMax.updateMatrices(size, mat, prots, builder, clusters, dq, y);
    }

    protected static <O> void updateMatrices(int size, MatrixParadigm mat, DBIDArrayMIter prots, PointerHierarchyRepresentationBuilder builder, Int2ObjectOpenHashMap<ModifiableDBIDs> clusters, DistanceQuery<O> dq, int c) {
        DBIDArrayIter ix = mat.ix;
        DBIDArrayIter iy = mat.iy;
        ix.seek(c);
        iy.seek(0);
        while (iy.getOffset() < c) {
            if (!builder.isLinked(iy)) {
                MiniMax.updateEntry(mat, prots, clusters, dq, c, iy.getOffset());
            }
            iy.advance();
        }
        iy.seek(c);
        ix.seek(c + 1);
        while (ix.valid()) {
            if (!builder.isLinked(ix)) {
                MiniMax.updateEntry(mat, prots, clusters, dq, ix.getOffset(), c);
            }
            ix.advance();
        }
    }

    protected static void updateEntry(MatrixParadigm mat, DBIDArrayMIter prots, Int2ObjectOpenHashMap<ModifiableDBIDs> clusters, DistanceQuery<?> dq, int x, int y) {
        double minMaxDist;
        assert (y < x);
        DBIDArrayIter ix = mat.ix;
        DBIDArrayIter iy = mat.iy;
        double[] distances = mat.matrix;
        ModifiableDBIDs cx = clusters.get(x);
        ModifiableDBIDs cy = clusters.get(y);
        DBIDVar prototype = DBIDUtil.newVar(ix.seek(x));
        if (cx != null && cy != null) {
            minMaxDist = MiniMax.findPrototype(dq, cx, cy, prototype, Double.POSITIVE_INFINITY);
            minMaxDist = MiniMax.findPrototype(dq, cy, cx, prototype, minMaxDist);
        } else if (cx != null) {
            minMaxDist = MiniMax.findPrototypeSingleton(dq, cx, iy.seek(y), prototype);
        } else if (cy != null) {
            minMaxDist = MiniMax.findPrototypeSingleton(dq, cy, ix.seek(x), prototype);
        } else {
            minMaxDist = dq.distance((DBIDRef)ix.seek(x), (DBIDRef)iy.seek(y));
            prototype.set(ix);
        }
        int offset = MatrixParadigm.triangleSize(x) + y;
        distances[offset] = minMaxDist;
        prots.seek(offset).setDBID(prototype);
    }

    private static double findPrototype(DistanceQuery<?> dq, DBIDs cx, DBIDs cy, DBIDVar prototype, double minMaxDist) {
        DBIDIter i = cx.iter();
        while (i.valid()) {
            double maxDist = MiniMax.findMax(dq, i, cy, 0.0, minMaxDist);
            if (!(maxDist >= minMaxDist) && (maxDist = MiniMax.findMax(dq, i, cx, maxDist, minMaxDist)) < minMaxDist) {
                minMaxDist = maxDist;
                prototype.set(i);
            }
            i.advance();
        }
        return minMaxDist;
    }

    private static double findPrototypeSingleton(DistanceQuery<?> dq, DBIDs cx, DBIDRef cy, DBIDVar prototype) {
        double maxDisty = 0.0;
        double minMaxDist = Double.POSITIVE_INFINITY;
        DBIDIter i = cx.iter();
        while (i.valid()) {
            double maxDist = dq.distance((DBIDRef)i, cy);
            double d = maxDisty = maxDist > maxDisty ? maxDist : maxDisty;
            if (!(maxDist >= minMaxDist) && (maxDist = MiniMax.findMax(dq, i, cx, maxDist, minMaxDist)) < minMaxDist) {
                minMaxDist = maxDist;
                prototype.set(i);
            }
            i.advance();
        }
        if (maxDisty < minMaxDist) {
            minMaxDist = maxDisty;
            prototype.set(cy);
        }
        return minMaxDist;
    }

    private static double findMax(DistanceQuery<?> dq, DBIDIter i, DBIDs cy, double maxDist, double minMaxDist) {
        DBIDIter j = cy.iter();
        while (j.valid()) {
            double dist = dq.distance((DBIDRef)i, (DBIDRef)j);
            if (dist > maxDist) {
                if (dist >= minMaxDist) {
                    return dist;
                }
                maxDist = dist;
            }
            j.advance();
        }
        return maxDist;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        @Override
        protected MiniMax<O> makeInstance() {
            return new MiniMax(this.distanceFunction);
        }
    }
}

