/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.AGNES;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.MatrixParadigm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.MiniMax;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationBuilder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerPrototypeHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;

@Reference(authors="M. R. Anderberg", title="Hierarchical Clustering Methods", booktitle="Cluster Analysis for Applications", bibkey="books/academic/Anderberg73/Ch6")
@Priority(value=195)
public class MiniMaxAnderberg<O>
extends AbstractDistanceBasedAlgorithm<O, PointerHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(MiniMaxAnderberg.class);

    public MiniMaxAnderberg(DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
    }

    public PointerHierarchyRepresentationResult run(Database db, Relation<O> relation) {
        DistanceQuery<O> dq = DatabaseUtil.precomputedDistanceQuery(db, relation, this.getDistanceFunction(), LOG);
        DBIDs ids = relation.getDBIDs();
        int size = ids.size();
        PointerHierarchyRepresentationBuilder builder = new PointerHierarchyRepresentationBuilder(ids, dq.getDistanceFunction().isSquared());
        Int2ObjectOpenHashMap<ModifiableDBIDs> clusters = new Int2ObjectOpenHashMap<ModifiableDBIDs>();
        MatrixParadigm mat = new MatrixParadigm(ids);
        ArrayModifiableDBIDs prots = DBIDUtil.newArray(MatrixParadigm.triangleSize(size));
        DBIDArrayMIter protiter = prots.iter();
        MiniMax.initializeMatrices(mat, prots, dq);
        double[] bestd = new double[size];
        int[] besti = new int[size];
        MiniMaxAnderberg.initializeNNCache(mat.matrix, bestd, besti);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Agglomerative clustering", size - 1, LOG) : null;
        DBIDArrayIter ix = mat.ix;
        int end = size;
        for (int i = 1; i < size; ++i) {
            end = AGNES.shrinkActiveSet(ix, builder, end, this.findMerge(end, mat, protiter, builder, clusters, bestd, besti, dq));
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        return (PointerPrototypeHierarchyRepresentationResult)builder.complete();
    }

    private static void initializeNNCache(double[] scratch, double[] bestd, int[] besti) {
        int size = bestd.length;
        Arrays.fill(bestd, Double.POSITIVE_INFINITY);
        Arrays.fill(besti, -1);
        int p = 0;
        for (int x = 0; x < size; ++x) {
            assert (p == MatrixParadigm.triangleSize(x));
            double bestdx = Double.POSITIVE_INFINITY;
            int bestix = -1;
            int y = 0;
            while (y < x) {
                double v = scratch[p];
                if (v < bestd[y]) {
                    bestd[y] = v;
                    besti[y] = x;
                }
                if (v < bestdx) {
                    bestdx = v;
                    bestix = y;
                }
                ++y;
                ++p;
            }
            bestd[x] = bestdx;
            besti[x] = bestix;
        }
    }

    protected int findMerge(int size, MatrixParadigm mat, DBIDArrayMIter prots, PointerHierarchyRepresentationBuilder builder, Int2ObjectOpenHashMap<ModifiableDBIDs> clusters, double[] bestd, int[] besti, DistanceQuery<O> dq) {
        double mindist = Double.POSITIVE_INFINITY;
        int x = -1;
        int y = -1;
        for (int cx = 0; cx < size; ++cx) {
            double dist;
            int cy = besti[cx];
            if (cy < 0 || !((dist = bestd[cx]) <= mindist)) continue;
            mindist = dist;
            x = cx;
            y = cy;
        }
        assert (x >= 0 && y >= 0);
        if (y > x) {
            int tmp = x;
            x = y;
            y = tmp;
        }
        assert (y < x);
        this.merge(size, mat, prots, builder, clusters, dq, bestd, besti, x, y);
        return x;
    }

    protected void merge(int size, MatrixParadigm mat, DBIDArrayMIter prots, PointerHierarchyRepresentationBuilder builder, Int2ObjectOpenHashMap<ModifiableDBIDs> clusters, DistanceQuery<O> dq, double[] bestd, int[] besti, int x, int y) {
        DBIDArrayIter ix = mat.ix.seek(x);
        DBIDArrayIter iy = mat.iy.seek(y);
        double[] distances = mat.matrix;
        int offset = MatrixParadigm.triangleSize(x) + y;
        assert (y < x);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Merging: " + DBIDUtil.toString(ix) + " -> " + DBIDUtil.toString(iy) + " " + distances[offset]);
        }
        ModifiableDBIDs cx = clusters.get(x);
        ModifiableDBIDs cy = clusters.get(y);
        if (cy == null) {
            cy = DBIDUtil.newHashSet();
            cy.add(iy);
        }
        if (cx == null) {
            cy.add(ix);
        } else {
            cy.addDBIDs(cx);
            clusters.remove(x);
        }
        clusters.put(y, cy);
        builder.add(ix, distances[offset], iy, prots.seek(offset));
        besti[x] = -1;
        this.updateMatrices(size, mat, prots, builder, clusters, dq, bestd, besti, x, y);
        if (besti[y] == x) {
            this.findBest(size, distances, bestd, besti, y);
        }
    }

    private void updateMatrices(int size, MatrixParadigm mat, DBIDArrayMIter prots, PointerHierarchyRepresentationBuilder builder, Int2ObjectOpenHashMap<ModifiableDBIDs> clusters, DistanceQuery<O> dq, double[] bestd, int[] besti, int x, int y) {
        int b;
        DBIDArrayIter ix = mat.ix;
        DBIDArrayIter iy = mat.iy;
        double[] distances = mat.matrix;
        int a = y;
        ix.seek(a);
        int yoffset = MatrixParadigm.triangleSize(y);
        for (b = 0; b < a; ++b) {
            if (builder.isLinked(iy.seek(b))) continue;
            MiniMax.updateEntry(mat, prots, clusters, dq, a, b);
            this.updateCache(size, distances, bestd, besti, x, y, b, distances[yoffset + b]);
        }
        b = y;
        iy.seek(b);
        for (a = y + 1; a < size; ++a) {
            if (builder.isLinked(ix.seek(a))) continue;
            MiniMax.updateEntry(mat, prots, clusters, dq, a, b);
            this.updateCache(size, distances, bestd, besti, x, y, a, distances[MatrixParadigm.triangleSize(a) + y]);
        }
    }

    private void updateCache(int size, double[] scratch, double[] bestd, int[] besti, int x, int y, int j, double d) {
        if (d <= bestd[j]) {
            bestd[j] = d;
            besti[j] = y;
            return;
        }
        if (besti[j] == x || besti[j] == y) {
            this.findBest(size, scratch, bestd, besti, j);
        }
    }

    protected void findBest(int size, double[] scratch, double[] bestd, int[] besti, int j) {
        double dist;
        int jbase = MatrixParadigm.triangleSize(j);
        double bestdj = Double.POSITIVE_INFINITY;
        int bestij = -1;
        int i = 0;
        int o = jbase;
        while (i < j) {
            if (besti[i] >= 0 && (dist = scratch[o]) < bestdj) {
                bestdj = dist;
                bestij = i;
            }
            ++i;
            ++o;
        }
        o = jbase + j + j;
        for (i = j + 1; i < size; ++i) {
            if (besti[i] >= 0 && (dist = scratch[o]) < bestdj) {
                bestdj = dist;
                bestij = i;
            }
            o += i;
        }
        bestd[j] = bestdj;
        besti[j] = bestij;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        @Override
        protected MiniMaxAnderberg<O> makeInstance() {
            return new MiniMaxAnderberg(this.distanceFunction);
        }
    }
}

