/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.AGNES;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.MatrixParadigm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.MiniMax;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.NNChain;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationBuilder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerPrototypeHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.IntegerArray;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

@References(value={@Reference(authors="F. Murtagh", title="A survey of recent advances in hierarchical clustering algorithms", booktitle="The Computer Journal 26(4)", url="https://doi.org/10.1093/comjnl/26.4.354", bibkey="DBLP:journals/cj/Murtagh83"), @Reference(authors="D. M\u00fcllner", title="Modern hierarchical, agglomerative clustering algorithms", booktitle="arXiv preprint arXiv:1109.2378", url="https://arxiv.org/abs/1109.2378", bibkey="DBLP:journals/corr/abs-1109-2378")})
public class MiniMaxNNChain<O>
extends AbstractDistanceBasedAlgorithm<O, PointerPrototypeHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(MiniMaxNNChain.class);

    public MiniMaxNNChain(DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
    }

    public PointerPrototypeHierarchyRepresentationResult run(Database db, Relation<O> relation) {
        DistanceQuery<O> dq = DatabaseUtil.precomputedDistanceQuery(db, relation, this.getDistanceFunction(), LOG);
        DBIDs ids = relation.getDBIDs();
        PointerHierarchyRepresentationBuilder builder = new PointerHierarchyRepresentationBuilder(ids, dq.getDistanceFunction().isSquared());
        Int2ObjectOpenHashMap<ModifiableDBIDs> clusters = new Int2ObjectOpenHashMap<ModifiableDBIDs>(ids.size());
        MatrixParadigm mat = new MatrixParadigm(ids);
        ArrayModifiableDBIDs prots = DBIDUtil.newArray(MatrixParadigm.triangleSize(ids.size()));
        MiniMax.initializeMatrices(mat, prots, dq);
        this.nnChainCore(mat, prots.iter(), dq, builder, clusters);
        return (PointerPrototypeHierarchyRepresentationResult)builder.complete();
    }

    private void nnChainCore(MatrixParadigm mat, DBIDArrayMIter prots, DistanceQuery<O> dq, PointerHierarchyRepresentationBuilder builder, Int2ObjectOpenHashMap<ModifiableDBIDs> clusters) {
        DBIDArrayIter ix = mat.ix;
        double[] distances = mat.matrix;
        int size = mat.size;
        IntegerArray chain = new IntegerArray(size + 1);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Running MiniMax-NNChain", size - 1, LOG) : null;
        int end = size;
        for (int k = 1; k < size; ++k) {
            int a = -1;
            int b = -1;
            if (chain.size() <= 3) {
                a = NNChain.findUnlinked(0, end, ix, builder);
                b = NNChain.findUnlinked(a + 1, end, ix, builder);
                chain.clear();
                chain.add(a);
            } else {
                int lastIndex = chain.size;
                int c = chain.get(lastIndex - 2);
                b = chain.get(lastIndex - 3);
                a = chain.get(lastIndex - 4);
                assert (chain.get(lastIndex - 1) == c || chain.get(lastIndex - 1) == b);
                b = c < b ? c : b;
                chain.size -= 3;
            }
            double minDist = mat.get(a, b);
            do {
                double dist;
                int i;
                int c = b;
                int ta = MatrixParadigm.triangleSize(a);
                for (i = 0; i < a; ++i) {
                    if (i == b || builder.isLinked(ix.seek(i)) || !((dist = distances[ta + i]) < minDist)) continue;
                    minDist = dist;
                    c = i;
                }
                for (i = a + 1; i < size; ++i) {
                    if (i == b || builder.isLinked(ix.seek(i)) || !((dist = distances[MatrixParadigm.triangleSize(i) + a]) < minDist)) continue;
                    minDist = dist;
                    c = i;
                }
                b = a;
                a = c;
                chain.add(a);
            } while (chain.size() < 3 || a != chain.get(chain.size - 1 - 2));
            if (a < b) {
                int tmp = a;
                a = b;
                b = tmp;
            }
            assert (minDist == mat.get(a, b));
            assert (b < a);
            MiniMax.merge(size, mat, prots, builder, clusters, dq, a, b);
            end = AGNES.shrinkActiveSet(ix, builder, end, a);
            LOG.incrementProcessed(progress);
        }
        LOG.ensureCompleted(progress);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        @Override
        protected MiniMaxNNChain<O> makeInstance() {
            return new MiniMaxNNChain(this.distanceFunction);
        }
    }
}

