/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.AGNES;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.MatrixParadigm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationBuilder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage.Linkage;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage.SingleLinkage;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.IntegerArray;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;

@References(value={@Reference(authors="F. Murtagh", title="A survey of recent advances in hierarchical clustering algorithms", booktitle="The Computer Journal 26(4)", url="https://doi.org/10.1093/comjnl/26.4.354", bibkey="DBLP:journals/cj/Murtagh83"), @Reference(authors="D. M\u00fcllner", title="Modern hierarchical, agglomerative clustering algorithms", booktitle="arXiv preprint arXiv:1109.2378", url="https://arxiv.org/abs/1109.2378", bibkey="DBLP:journals/corr/abs-1109-2378")})
public class NNChain<O>
extends AGNES<O> {
    private static final Logging LOG = Logging.getLogger(NNChain.class);

    public NNChain(DistanceFunction<? super O> distanceFunction, Linkage linkage) {
        super(distanceFunction, linkage);
    }

    @Override
    public PointerHierarchyRepresentationResult run(Database db, Relation<O> relation) {
        if (SingleLinkage.class.isInstance(this.linkage)) {
            LOG.verbose("Notice: SLINK is a much faster algorithm for single-linkage clustering!");
        }
        DistanceQuery<O> dq = db.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        DBIDs ids = relation.getDBIDs();
        MatrixParadigm mat = new MatrixParadigm(ids);
        NNChain.initializeDistanceMatrix(mat, dq, this.linkage);
        PointerHierarchyRepresentationBuilder builder = new PointerHierarchyRepresentationBuilder(ids, dq.getDistanceFunction().isSquared());
        this.nnChainCore(mat, builder);
        return builder.complete();
    }

    private void nnChainCore(MatrixParadigm mat, PointerHierarchyRepresentationBuilder builder) {
        DBIDArrayIter ix = mat.ix;
        double[] distances = mat.matrix;
        int size = mat.size;
        IntegerArray chain = new IntegerArray(size + 1);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Running NNChain", size - 1, LOG) : null;
        int end = size;
        for (int k = 1; k < size; ++k) {
            int a = -1;
            int b = -1;
            if (chain.size() <= 3) {
                a = NNChain.findUnlinked(0, end, ix, builder);
                b = NNChain.findUnlinked(a + 1, end, ix, builder);
                chain.clear();
                chain.add(a);
            } else {
                int lastIndex = chain.size;
                int c = chain.get(lastIndex - 2);
                b = chain.get(lastIndex - 3);
                a = chain.get(lastIndex - 4);
                assert (chain.get(lastIndex - 1) == c || chain.get(lastIndex - 1) == b);
                b = c < b ? c : b;
                chain.size -= 3;
            }
            double minDist = mat.get(a, b);
            do {
                double dist;
                int i;
                int c = b;
                int ta = MatrixParadigm.triangleSize(a);
                for (i = 0; i < a; ++i) {
                    if (i == b || builder.isLinked(ix.seek(i)) || !((dist = distances[ta + i]) < minDist)) continue;
                    minDist = dist;
                    c = i;
                }
                for (i = a + 1; i < size; ++i) {
                    if (i == b || builder.isLinked(ix.seek(i)) || !((dist = distances[MatrixParadigm.triangleSize(i) + a]) < minDist)) continue;
                    minDist = dist;
                    c = i;
                }
                b = a;
                a = c;
                chain.add(a);
            } while (chain.size() < 3 || a != chain.get(chain.size - 1 - 2));
            if (a < b) {
                int tmp = a;
                a = b;
                b = tmp;
            }
            assert (minDist == mat.get(a, b));
            assert (b < a);
            this.merge(size, mat, builder, minDist, a, b);
            end = AGNES.shrinkActiveSet(ix, builder, end, a);
            LOG.incrementProcessed(progress);
        }
        LOG.ensureCompleted(progress);
    }

    public static int findUnlinked(int pos, int end, DBIDArrayIter ix, PointerHierarchyRepresentationBuilder builder) {
        while (pos < end) {
            if (!builder.isLinked(ix.seek(pos))) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AGNES.Parameterizer<O> {
        @Override
        protected NNChain<O> makeInstance() {
            return new NNChain(this.distanceFunction, this.linkage);
        }
    }
}

