/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerPrototypeHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;

public class PointerHierarchyRepresentationBuilder {
    private static final Logging LOG = Logging.getLogger(PointerHierarchyRepresentationBuilder.class);
    protected final DBIDs ids;
    protected WritableDBIDDataStore parent;
    protected WritableDoubleDataStore parentDistance;
    protected WritableIntegerDataStore csize;
    protected WritableIntegerDataStore order;
    protected int mergecount = 0;
    protected WritableDBIDDataStore prototypes;
    protected boolean isSquared;

    public PointerHierarchyRepresentationBuilder(DBIDs ids, boolean isSquared) {
        this.ids = ids;
        this.parent = DataStoreUtil.makeDBIDStorage(ids, 30);
        this.parentDistance = DataStoreUtil.makeDoubleStorage(ids, 30, Double.POSITIVE_INFINITY);
        DBIDIter it = ids.iter();
        while (it.valid()) {
            this.parent.put((DBIDRef)it, it);
            it.advance();
        }
        this.order = DataStoreUtil.makeIntegerStorage(ids, 30, ids.size());
        this.isSquared = isSquared;
    }

    public void add(DBIDRef cur, double distance, DBIDRef par) {
        assert (this.prototypes == null);
        this.parent.putDBID(cur, par);
        double olddist = this.parentDistance.putDouble(cur, distance);
        assert (olddist == Double.POSITIVE_INFINITY) : "Object was already linked!";
        this.order.putInt(cur, this.mergecount);
        ++this.mergecount;
    }

    public void add(DBIDRef cur, double distance, DBIDRef par, DBIDRef prototype) {
        if (this.mergecount == 0) {
            this.prototypes = DataStoreUtil.makeDBIDStorage(this.ids, 30);
        }
        assert (this.prototypes != null);
        this.parent.putDBID(cur, par);
        this.prototypes.putDBID(cur, prototype);
        double olddist = this.parentDistance.putDouble(cur, distance);
        assert (olddist == Double.POSITIVE_INFINITY) : "Object was already linked!";
        this.order.putInt(cur, this.mergecount);
        ++this.mergecount;
    }

    public PointerHierarchyRepresentationResult complete() {
        if (this.csize != null) {
            this.csize.destroy();
            this.csize = null;
        }
        if (this.mergecount != this.ids.size() - 1) {
            LOG.warning(this.mergecount + " merges were added to the hierarchy, expected " + (this.ids.size() - 1));
        }
        if (this.prototypes != null) {
            return new PointerPrototypeHierarchyRepresentationResult(this.ids, this.parent, this.parentDistance, this.isSquared, this.order, this.prototypes);
        }
        return new PointerHierarchyRepresentationResult(this.ids, this.parent, this.parentDistance, this.isSquared, this.order);
    }

    public int getSize(DBIDRef id) {
        if (this.csize == null) {
            this.csize = DataStoreUtil.makeIntegerStorage(this.ids, 3, 1);
        }
        return this.csize.intValue(id);
    }

    public void setSize(DBIDRef id, int size) {
        if (this.csize == null) {
            this.csize = DataStoreUtil.makeIntegerStorage(this.ids, 3, 1);
        }
        this.csize.putInt(id, size);
    }

    public boolean isLinked(DBIDRef id) {
        return this.parentDistance.doubleValue(id) < Double.POSITIVE_INFINITY;
    }

    public double getDistance(DBIDRef id) {
        return this.parentDistance.doubleValue(id);
    }
}

