/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.IntegerDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import java.util.Comparator;

public class PointerHierarchyRepresentationResult
extends BasicResult {
    DBIDs ids;
    DBIDDataStore parent;
    DoubleDataStore parentDistance;
    IntegerDataStore positions = null;
    IntegerDataStore mergeOrder = null;
    boolean isSquared = false;

    public PointerHierarchyRepresentationResult(DBIDs ids, DBIDDataStore parent, DoubleDataStore parentDistance, boolean isSquared) {
        this(ids, parent, parentDistance, isSquared, null);
    }

    public PointerHierarchyRepresentationResult(DBIDs ids, DBIDDataStore parent, DoubleDataStore parentDistance, boolean isSquared, IntegerDataStore mergeOrder) {
        super("Pointer Representation", "pointer-representation");
        this.ids = ids;
        this.parent = parent;
        this.parentDistance = parentDistance;
        this.mergeOrder = mergeOrder;
        this.isSquared = isSquared;
    }

    public DBIDs getDBIDs() {
        return this.ids;
    }

    public DBIDDataStore getParentStore() {
        return this.parent;
    }

    public DoubleDataStore getParentDistanceStore() {
        return this.parentDistance;
    }

    public IntegerDataStore getPositions() {
        if (this.positions != null) {
            return this.positions;
        }
        ArrayDBIDs order = this.topologicalSort();
        WritableIntegerDataStore siz = this.computeSubtreeSizes(order);
        WritableIntegerDataStore pos = DataStoreUtil.makeIntegerStorage(this.ids, 30, -1);
        WritableIntegerDataStore ins = DataStoreUtil.makeIntegerStorage(this.ids, 3, -1);
        int defins = 0;
        DBIDVar v1 = DBIDUtil.newVar();
        DBIDArrayIter it = order.iter().seek(order.size() - 1);
        while (it.valid()) {
            int size = siz.intValue(it);
            this.parent.assignVar(it, v1);
            int ipos = ins.intValue(v1);
            if (ipos < 0 || DBIDUtil.equal(it, v1)) {
                ins.putInt(it, defins);
                pos.putInt(it, defins + size - 1);
                defins += size;
            } else {
                pos.putInt(it, ipos + size - 1);
                ins.putInt(it, ipos);
                ins.increment(v1, size);
            }
            it.retract();
        }
        siz.destroy();
        ins.destroy();
        this.positions = pos;
        return this.positions;
    }

    public boolean isSquared() {
        return this.isSquared;
    }

    private WritableIntegerDataStore computeSubtreeSizes(DBIDs order) {
        WritableIntegerDataStore siz = DataStoreUtil.makeIntegerStorage(this.ids, 3, 1);
        DBIDVar v1 = DBIDUtil.newVar();
        DBIDIter it = order.iter();
        while (it.valid()) {
            if (!DBIDUtil.equal(it, this.parent.assignVar(it, v1))) {
                siz.increment(v1, siz.intValue(it));
            }
            it.advance();
        }
        return siz;
    }

    private WritableDoubleDataStore computeMaxHeight() {
        WritableDoubleDataStore maxheight = DataStoreUtil.makeDoubleStorage(this.ids, 3, 0.0);
        DBIDVar v1 = DBIDUtil.newVar();
        DBIDIter it = this.ids.iter();
        while (it.valid()) {
            double d = this.parentDistance.doubleValue(it);
            if (d > maxheight.doubleValue(it)) {
                maxheight.putDouble(it, d);
            }
            if (d > maxheight.doubleValue(this.parent.assignVar(it, v1))) {
                maxheight.putDouble(v1, d);
            }
            it.advance();
        }
        return maxheight;
    }

    public ArrayDBIDs topologicalSort() {
        ArrayModifiableDBIDs ids = DBIDUtil.newArray(this.ids);
        if (this.mergeOrder != null) {
            ids.sort(new DataStoreUtil.AscendingByIntegerDataStore(this.mergeOrder));
            WritableDoubleDataStore maxheight = this.computeMaxHeight();
            ids.sort(new Sorter(maxheight));
            maxheight.destroy();
        } else {
            ids.sort(new DataStoreUtil.DescendingByDoubleDataStoreAndId(this.parentDistance));
        }
        int size = ids.size();
        HashSetModifiableDBIDs seen = DBIDUtil.newHashSet(size);
        ArrayModifiableDBIDs order = DBIDUtil.newArray(size);
        DBIDVar v1 = DBIDUtil.newVar();
        DBIDVar prev = DBIDUtil.newVar();
        DBIDArrayMIter it = ids.iter();
        while (it.valid()) {
            if (seen.add(it)) {
                int begin = order.size();
                order.add(it);
                prev.set(it);
                while (!DBIDUtil.equal(prev, this.parent.assignVar(prev, v1)) && seen.add(v1)) {
                    order.add(v1);
                    prev.set(v1);
                }
                int i = begin;
                for (int j = order.size() - 1; i < j; ++i, --j) {
                    order.swap(i, j);
                }
            }
            it.advance();
        }
        int i = 0;
        for (int j = size - 1; i < j; ++i, --j) {
            order.swap(i, j);
        }
        return order;
    }

    private final class Sorter
    implements Comparator<DBIDRef> {
        private WritableDoubleDataStore maxheight;

        public Sorter(WritableDoubleDataStore maxheight) {
            this.maxheight = maxheight;
        }

        @Override
        public int compare(DBIDRef o1, DBIDRef o2) {
            int c = Double.compare(this.maxheight.doubleValue(o2), this.maxheight.doubleValue(o1));
            if (c == 0) {
                c = Double.compare(PointerHierarchyRepresentationResult.this.parentDistance.doubleValue(o2), PointerHierarchyRepresentationResult.this.parentDistance.doubleValue(o1));
            }
            if (c == 0) {
                c = Integer.compare(PointerHierarchyRepresentationResult.this.mergeOrder.intValue(o2), PointerHierarchyRepresentationResult.this.mergeOrder.intValue(o1));
            }
            return c;
        }
    }
}

