/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.IntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;

public class PointerPrototypeHierarchyRepresentationResult
extends PointerHierarchyRepresentationResult {
    DBIDDataStore prototypes;

    public PointerPrototypeHierarchyRepresentationResult(DBIDs ids, DBIDDataStore parent, DoubleDataStore parentDistance, boolean isSquared, IntegerDataStore mergeOrder, DBIDDataStore prototypes) {
        super(ids, parent, parentDistance, isSquared, mergeOrder);
        this.prototypes = prototypes;
    }

    public PointerPrototypeHierarchyRepresentationResult(DBIDs ids, DBIDDataStore parent, DoubleDataStore parentDistance, boolean isSquared, DBIDDataStore prototypes) {
        this(ids, parent, parentDistance, isSquared, null, prototypes);
    }

    public DBIDDataStore getPrototypes() {
        return this.prototypes;
    }

    public DBID findPrototype(DBIDs members) {
        DBIDIter it = members.iter();
        DBIDVar proto = DBIDUtil.newVar(it);
        DBIDVar last = DBIDUtil.newVar(it);
        int maxprio = Integer.MIN_VALUE;
        int secprio = Integer.MIN_VALUE;
        while (it.valid()) {
            int prio = this.mergeOrder.intValue(it);
            if (prio > maxprio) {
                secprio = maxprio;
                proto.set(last);
                maxprio = prio;
                last.set(it);
            } else if (prio > secprio) {
                secprio = prio;
                proto.set(it);
            }
            it.advance();
        }
        return DBIDUtil.deref(this.prototypes.assignVar(proto, proto));
    }
}

