/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="SLINK: Single Link Clustering")
@Description(value="Hierarchical clustering algorithm based on single-link connectivity.")
@Reference(authors="R. Sibson", title="SLINK: An optimally efficient algorithm for the single-link cluster method", booktitle="The Computer Journal 16 (1973), No. 1, p. 30-34.", url="https://doi.org/10.1093/comjnl/16.1.30", bibkey="DBLP:journals/cj/Sibson73")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.SLINK", "clustering.SLINK", "single-link", "single-linkage"})
@Priority(value=200)
public class SLINK<O>
extends AbstractDistanceBasedAlgorithm<O, PointerHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(SLINK.class);

    public SLINK(DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
    }

    public PointerHierarchyRepresentationResult run(Database database, Relation<O> relation) {
        DBIDs ids = relation.getDBIDs();
        WritableDBIDDataStore pi = DataStoreUtil.makeDBIDStorage(ids, 6);
        WritableDoubleDataStore lambda = DataStoreUtil.makeDoubleStorage(ids, 6, Double.POSITIVE_INFINITY);
        WritableDoubleDataStore m = DataStoreUtil.makeDoubleStorage(ids, 3);
        Logging log = this.getLogger();
        FiniteProgress progress = log.isVerbose() ? new FiniteProgress("Running SLINK", ids.size(), log) : null;
        ArrayDBIDs aids = DBIDUtil.ensureArray(ids);
        DBIDArrayIter id = aids.iter();
        DBIDArrayIter it = aids.iter();
        while (id.valid()) {
            pi.put((DBIDRef)id, id);
            id.advance();
        }
        log.incrementProcessed(progress);
        if (this.getDistanceFunction() instanceof PrimitiveDistanceFunction) {
            PrimitiveDistanceFunction distf = (PrimitiveDistanceFunction)this.getDistanceFunction();
            id.seek(1);
            while (id.valid()) {
                this.step2primitive(id, it, id.getOffset(), relation, distf, m);
                this.process(id, aids, it, id.getOffset(), pi, lambda, m);
                log.incrementProcessed(progress);
                id.advance();
            }
        } else {
            DistanceQuery<O> distQ = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
            id.seek(1);
            while (id.valid()) {
                this.step2(id, it, id.getOffset(), distQ, m);
                this.process(id, aids, it, id.getOffset(), pi, lambda, m);
                log.incrementProcessed(progress);
                id.advance();
            }
        }
        log.ensureCompleted(progress);
        m.destroy();
        m = null;
        return new PointerHierarchyRepresentationResult(ids, pi, lambda, this.getDistanceFunction().isSquared());
    }

    private void step2(DBIDRef id, DBIDArrayIter it, int n, DistanceQuery<? super O> distQuery, WritableDoubleDataStore m) {
        it.seek(0);
        while (it.getOffset() < n) {
            m.putDouble(it, distQuery.distance((DBIDRef)it, id));
            it.advance();
        }
    }

    private void step2primitive(DBIDRef id, DBIDArrayIter it, int n, Relation<? extends O> relation, PrimitiveDistanceFunction<? super O> distFunc, WritableDoubleDataStore m) {
        O newObj = relation.get(id);
        it.seek(0);
        while (it.getOffset() < n) {
            m.putDouble(it, distFunc.distance(relation.get(it), newObj));
            it.advance();
        }
    }

    protected void process(DBIDRef id, ArrayDBIDs ids, DBIDArrayIter it, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, WritableDoubleDataStore m) {
        this.slinkstep3(id, it, n, pi, lambda, m);
        this.slinkstep4(id, it, n, pi, lambda);
    }

    private void slinkstep3(DBIDRef id, DBIDArrayIter it, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, WritableDoubleDataStore m) {
        DBIDVar p_i = DBIDUtil.newVar();
        it.seek(0);
        while (it.getOffset() < n) {
            double l_i = lambda.doubleValue(it);
            double m_i = m.doubleValue(it);
            p_i.from(pi, it);
            double mp_i = m.doubleValue(p_i);
            if (l_i >= m_i) {
                if (l_i < mp_i) {
                    m.putDouble(p_i, l_i);
                }
                lambda.putDouble(it, m_i);
                pi.put((DBIDRef)it, id);
            } else if (m_i < mp_i) {
                m.putDouble(p_i, m_i);
            }
            it.advance();
        }
    }

    private void slinkstep4(DBIDRef id, DBIDArrayIter it, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda) {
        DBIDVar p_i = DBIDUtil.newVar();
        it.seek(0);
        while (it.getOffset() < n) {
            double l_i = lambda.doubleValue(it);
            p_i.from(pi, it);
            double lp_i = lambda.doubleValue(p_i);
            if (l_i >= lp_i) {
                pi.put((DBIDRef)it, id);
            }
            it.advance();
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        @Override
        protected SLINK<O> makeInstance() {
            return new SLINK(this.distanceFunction);
        }
    }
}

