/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.AbstractHDBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerDensityHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="R. J. G. B. Campello, D. Moulavi, J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conf. Advances in Knowledge Discovery and Data Mining (PAKDD)", url="https://doi.org/10.1007/978-3-642-37456-2_14", bibkey="DBLP:conf/pakdd/CampelloMS13")
public class SLINKHDBSCANLinearMemory<O>
extends AbstractHDBSCAN<O, PointerDensityHierarchyRepresentationResult>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(SLINKHDBSCANLinearMemory.class);

    public SLINKHDBSCANLinearMemory(DistanceFunction<? super O> distanceFunction, int minPts) {
        super(distanceFunction, minPts);
    }

    public PointerDensityHierarchyRepresentationResult run(Database db, Relation<O> relation) {
        DistanceQuery<O> distQ = db.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> knnQ = db.getKNNQuery(distQ, this.minPts);
        ArrayDBIDs ids = DBIDUtil.ensureArray(relation.getDBIDs());
        WritableDoubleDataStore coredists = this.computeCoreDists(ids, knnQ, this.minPts);
        WritableDBIDDataStore pi = DataStoreUtil.makeDBIDStorage(ids, 6);
        WritableDoubleDataStore lambda = DataStoreUtil.makeDoubleStorage(ids, 6, Double.POSITIVE_INFINITY);
        WritableDoubleDataStore m = DataStoreUtil.makeDoubleStorage(ids, 3);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Running HDBSCAN*-SLINK", ids.size(), LOG) : null;
        ArrayModifiableDBIDs processedIDs = DBIDUtil.newArray(ids.size());
        DBIDArrayIter id = ids.iter();
        while (id.valid()) {
            this.step1(id, pi, lambda);
            this.step2(id, processedIDs, distQ, coredists, m);
            this.step3(id, pi, lambda, processedIDs, m);
            this.step4(id, pi, lambda, processedIDs);
            processedIDs.add(id);
            LOG.incrementProcessed(progress);
            id.advance();
        }
        LOG.ensureCompleted(progress);
        return new PointerDensityHierarchyRepresentationResult((DBIDs)ids, (DBIDDataStore)pi, (DoubleDataStore)lambda, distQ.getDistanceFunction().isSquared(), coredists);
    }

    private void step1(DBIDRef id, WritableDBIDDataStore pi, WritableDoubleDataStore lambda) {
        pi.put(id, id);
    }

    private void step2(DBIDRef id, DBIDs processedIDs, DistanceQuery<? super O> distQuery, DoubleDataStore coredists, WritableDoubleDataStore m) {
        double coreP = coredists.doubleValue(id);
        DBIDIter it = processedIDs.iter();
        while (it.valid()) {
            double coreQ = coredists.doubleValue(it);
            double dist = MathUtil.max(coreP, coreQ, distQuery.distance(id, (DBIDRef)it));
            m.putDouble(it, dist);
            it.advance();
        }
    }

    private void step3(DBIDRef id, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, DBIDs processedIDs, WritableDoubleDataStore m) {
        DBIDVar p_i = DBIDUtil.newVar();
        DBIDIter it = processedIDs.iter();
        while (it.valid()) {
            double l_i = lambda.doubleValue(it);
            double m_i = m.doubleValue(it);
            pi.assignVar(it, p_i);
            double mp_i = m.doubleValue(p_i);
            if (l_i >= m_i) {
                if (l_i < mp_i) {
                    m.putDouble(p_i, l_i);
                }
                lambda.putDouble(it, m_i);
                pi.put((DBIDRef)it, id);
            } else if (m_i < mp_i) {
                m.putDouble(p_i, m_i);
            }
            it.advance();
        }
    }

    private void step4(DBIDRef id, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, DBIDs processedIDs) {
        DBIDVar p_i = DBIDUtil.newVar();
        DBIDIter it = processedIDs.iter();
        while (it.valid()) {
            double l_i = lambda.doubleValue(it);
            pi.assignVar(it, p_i);
            double lp_i = lambda.doubleValue(p_i);
            if (l_i >= lp_i) {
                pi.put((DBIDRef)it, id);
            }
            it.advance();
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractHDBSCAN.Parameterizer<O> {
        @Override
        protected SLINKHDBSCANLinearMemory<O> makeInstance() {
            return new SLINKHDBSCANLinearMemory(this.distanceFunction, this.minPts);
        }
    }
}

