/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.birch;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.birch.BIRCHDistance;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.birch.ClusteringFeature;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"D2"})
@Reference(authors="T. Zhang", title="Data Clustering for Very Large Datasets Plus Applications", booktitle="University of Wisconsin Madison, Technical Report #1355", url="ftp://ftp.cs.wisc.edu/pub/techreports/1997/TR1355.pdf", bibkey="tr/wisc/Zhang97")
public class AverageInterclusterDistance
implements BIRCHDistance {
    public static final AverageInterclusterDistance STATIC = new AverageInterclusterDistance();

    @Override
    public double squaredDistance(NumberVector v, ClusteringFeature cf) {
        int dim = v.getDimensionality();
        assert (dim == cf.getDimensionality());
        double sum = 0.0;
        for (int d = 0; d < dim; ++d) {
            sum += v.doubleValue(d) * cf.ls[d];
        }
        sum = cf.sumOfSumOfSquares() + (double)cf.n * ClusteringFeature.sumOfSquares(v) - 2.0 * sum;
        return sum > 0.0 ? sum / (double)cf.n : 0.0;
    }

    @Override
    public double squaredDistance(ClusteringFeature cf1, ClusteringFeature cf2) {
        int dim = cf1.getDimensionality();
        assert (dim == cf2.getDimensionality());
        double sum = 0.0;
        for (int d = 0; d < dim; ++d) {
            sum += cf1.ls[d] * cf2.ls[d];
        }
        sum = (double)cf2.n * cf1.sumOfSumOfSquares() + (double)cf1.n * cf2.sumOfSumOfSquares() - 2.0 * sum;
        return sum > 0.0 ? sum / (double)((long)cf1.n * (long)cf2.n) : 0.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected AverageInterclusterDistance makeInstance() {
            return STATIC;
        }
    }
}

