/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.birch;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.birch.CFTree;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.birch.ClusteringFeature;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.HashMap;
import java.util.Map;

@References(value={@Reference(authors="T. Zhang, R. Ramakrishnan, M. Livny", title="BIRCH: An Efficient Data Clustering Method for Very Large Databases", booktitle="Proc. 1996 ACM SIGMOD International Conference on Management of Data", url="https://doi.org/10.1145/233269.233324", bibkey="DBLP:conf/sigmod/ZhangRL96"), @Reference(authors="T. Zhang, R. Ramakrishnan, M. Livny", title="BIRCH: A New Data Clustering Algorithm and Its Applications", booktitle="Data Min. Knowl. Discovery", url="https://doi.org/10.1023/A:1009783824328", bibkey="DBLP:journals/datamine/ZhangRL97")})
public class BIRCHLeafClustering
extends AbstractAlgorithm<Clustering<MeanModel>>
implements ClusteringAlgorithm<Clustering<MeanModel>> {
    private static final Logging LOG = Logging.getLogger(BIRCHLeafClustering.class);
    CFTree.Factory cffactory;

    public BIRCHLeafClustering(CFTree.Factory cffactory) {
        this.cffactory = cffactory;
    }

    public Clustering<MeanModel> run(Relation<NumberVector> relation) {
        int dim = RelationUtil.dimensionality(relation);
        CFTree tree = this.cffactory.newTree(relation.getDBIDs(), relation);
        HashMap<ClusteringFeature, ArrayModifiableDBIDs> idmap = new HashMap<ClusteringFeature, ArrayModifiableDBIDs>(tree.leaves);
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            ClusteringFeature cf = tree.findLeaf(relation.get(iter));
            ModifiableDBIDs ids = (ModifiableDBIDs)idmap.get(cf);
            if (ids == null) {
                ids = DBIDUtil.newArray(cf.n);
                idmap.put(cf, (ArrayModifiableDBIDs)ids);
            }
            ids.add(iter);
            iter.advance();
        }
        Clustering<MeanModel> result = new Clustering<MeanModel>("BIRCH-leaves", "BIRCH leaves");
        for (Map.Entry ent : idmap.entrySet()) {
            ClusteringFeature leaf = (ClusteringFeature)ent.getKey();
            double[] center = new double[dim];
            for (int i = 0; i < dim; ++i) {
                center[i] = leaf.centroid(i);
            }
            result.addToplevelCluster(new Cluster<MeanModel>((DBIDs)ent.getValue(), new MeanModel(center)));
        }
        return result;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        CFTree.Factory cffactory;

        @Override
        protected void makeOptions(Parameterization config) {
            this.cffactory = config.tryInstantiate(CFTree.Factory.class);
        }

        @Override
        protected BIRCHLeafClustering makeInstance() {
            return new BIRCHLeafClustering(this.cffactory);
        }
    }
}

