/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.birch;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.birch.BIRCHAbsorptionCriterion;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.birch.ClusteringFeature;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"D"})
@Reference(authors="T. Zhang, R. Ramakrishnan, M. Livny", title="BIRCH: An Efficient Data Clustering Method for Very Large Databases", booktitle="Proc. 1996 ACM SIGMOD International Conference on Management of Data", url="https://doi.org/10.1145/233269.233324", bibkey="DBLP:conf/sigmod/ZhangRL96")
public class DiameterCriterion
implements BIRCHAbsorptionCriterion {
    public static final DiameterCriterion STATIC = new DiameterCriterion();

    @Override
    public double squaredCriterion(ClusteringFeature f1, NumberVector n) {
        if (f1.n <= 0) {
            return 0.0;
        }
        double sum1 = f1.ss;
        double sum2 = 0.0;
        for (int i = 0; i < f1.ls.length; ++i) {
            double x = n.doubleValue(i);
            sum1 += x * x;
            double v = f1.ls[i] + x;
            sum2 += v * v;
        }
        double diameter = sum1 * (double)(f1.n + 1) - sum2;
        return diameter > 0.0 ? diameter * 2.0 / (((double)f1.n + 1.0) * (double)f1.n) : 0.0;
    }

    @Override
    public double squaredCriterion(ClusteringFeature f1, ClusteringFeature f2) {
        int n12 = f1.n + f2.n;
        if (n12 <= 0) {
            return 0.0;
        }
        double sum1 = f1.ss + f2.ss;
        double sum2 = 0.0;
        for (int i = 0; i < f1.ls.length; ++i) {
            double v = f1.ls[i] + f2.ls[i];
            sum2 += v * v;
        }
        double diameter = sum1 * (double)n12 - sum2;
        return diameter > 0.0 ? diameter * 2.0 / (double)((long)n12 * ((long)n12 - 1L)) : 0.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected DiameterCriterion makeInstance() {
            return STATIC;
        }
    }
}

