/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.birch;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.birch.BIRCHAbsorptionCriterion;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.birch.ClusteringFeature;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class EuclideanDistanceCriterion
implements BIRCHAbsorptionCriterion {
    public static final EuclideanDistanceCriterion STATIC = new EuclideanDistanceCriterion();

    @Override
    public double squaredCriterion(ClusteringFeature f1, NumberVector n) {
        assert (f1.n > 0);
        int dim = f1.ls.length;
        double div = 1.0 / (double)f1.n;
        double sum = 0.0;
        for (int d = 0; d < dim; ++d) {
            double v = f1.ls[d] * div - n.doubleValue(d);
            sum += v * v;
        }
        return sum;
    }

    @Override
    public double squaredCriterion(ClusteringFeature f1, ClusteringFeature f2) {
        assert (f1.n > 0 && f2.n > 0);
        int dim = f1.ls.length;
        double div1 = 1.0 / (double)f1.n;
        double div2 = 1.0 / (double)f2.n;
        double sum = 0.0;
        for (int d = 0; d < dim; ++d) {
            double v = f1.ls[d] * div1 - f2.ls[d] * div2;
            sum += v * v;
        }
        return sum;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected EuclideanDistanceCriterion makeInstance() {
            return STATIC;
        }
    }
}

