/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerPrototypeHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.DendrogramModel;
import de.lmu.ifi.dbs.elki.data.model.PrototypeDendrogramModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArray;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;

public abstract class AbstractCutDendrogram
implements ClusteringAlgorithm<Clustering<DendrogramModel>> {
    protected final boolean hierarchical;
    protected final HierarchicalClusteringAlgorithm algorithm;

    public AbstractCutDendrogram(HierarchicalClusteringAlgorithm algorithm, boolean hierarchical) {
        this.algorithm = algorithm;
        this.hierarchical = hierarchical;
    }

    @Override
    public Clustering<DendrogramModel> run(Database database) {
        PointerHierarchyRepresentationResult pointerresult = this.algorithm.run(database);
        return this.run(pointerresult);
    }

    public abstract Clustering<DendrogramModel> run(PointerHierarchyRepresentationResult var1);

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.algorithm.getInputTypeRestriction();
    }

    protected abstract Logging getLogger();

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID HIERARCHICAL_ID = new OptionID("hierarchical.hierarchy", "Generate a truncated hierarchical clustering result (or strict partitions).");
        boolean hierarchical = false;
        HierarchicalClusteringAlgorithm algorithm;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag hierarchicalF;
            super.makeOptions(config);
            ObjectParameter algorithmP = new ObjectParameter(AbstractAlgorithm.ALGORITHM_ID, HierarchicalClusteringAlgorithm.class);
            if (config.grab(algorithmP)) {
                this.algorithm = (HierarchicalClusteringAlgorithm)algorithmP.instantiateClass(config);
            }
            if (config.grab(hierarchicalF = new Flag(HIERARCHICAL_ID))) {
                this.hierarchical = hierarchicalF.isTrue();
            }
        }
    }

    public abstract class Instance {
        protected ArrayDBIDs ids;
        protected DBIDDataStore pi;
        protected DoubleDataStore lambda;
        protected PointerHierarchyRepresentationResult pointerresult;
        protected WritableIntegerDataStore cluster_map;
        protected ArrayList<ModifiableDBIDs> cluster_dbids;
        protected DoubleArray clusterHeight;
        protected ArrayModifiableDBIDs cluster_leads;

        public Instance(PointerHierarchyRepresentationResult pointerresult) {
            this.ids = pointerresult.topologicalSort();
            this.pi = pointerresult.getParentStore();
            this.lambda = pointerresult.getParentDistanceStore();
            this.pointerresult = pointerresult;
        }

        public Clustering<DendrogramModel> extractClusters() {
            Logging log = AbstractCutDendrogram.this.getLogger();
            DBIDArrayIter it = this.pointerresult.topologicalSort().iter();
            int split = this.findSplit(it);
            FiniteProgress progress = log.isVerbose() ? new FiniteProgress("Extracting clusters", this.ids.size(), log) : null;
            int expcnum = this.ids.size() - split;
            this.cluster_map = DataStoreUtil.makeIntegerStorage(this.ids, 1, -1);
            this.cluster_dbids = new ArrayList(expcnum + 10);
            this.clusterHeight = new DoubleArray(expcnum + 10);
            this.cluster_leads = DBIDUtil.newArray(expcnum + 10);
            this.buildLeafClusters(it, split, progress);
            Clustering<DendrogramModel> dendrogram = AbstractCutDendrogram.this.hierarchical ? this.buildHierarchical(it, split, progress) : this.buildFlat(it, split, progress);
            log.ensureCompleted(progress);
            return dendrogram;
        }

        private void buildLeafClusters(DBIDArrayIter it, int split, FiniteProgress progress) {
            Logging log = AbstractCutDendrogram.this.getLogger();
            DBIDVar succ = DBIDUtil.newVar();
            it.seek(split - 1);
            while (it.valid()) {
                double dist = this.lambda.doubleValue(it);
                this.pi.assignVar(it, succ);
                int clusterid = this.cluster_map.intValue(succ);
                if (clusterid >= 0) {
                    this.cluster_dbids.get(clusterid).add(it);
                    this.cluster_map.putInt(it, clusterid);
                    if (this.clusterHeight.get(clusterid) < dist) {
                        this.clusterHeight.set(clusterid, dist);
                    }
                } else {
                    clusterid = this.cluster_dbids.size();
                    ArrayModifiableDBIDs cids = DBIDUtil.newArray();
                    cids.add(succ);
                    this.cluster_map.putInt(succ, clusterid);
                    cids.add(it);
                    this.cluster_map.putInt(it, clusterid);
                    this.cluster_dbids.add(cids);
                    this.cluster_leads.add(succ);
                    this.clusterHeight.add(dist);
                }
                log.incrementProcessed(progress);
                it.retract();
            }
        }

        private Clustering<DendrogramModel> buildFlat(DBIDArrayIter it, int split, FiniteProgress progress) {
            Logging log = AbstractCutDendrogram.this.getLogger();
            Clustering<DendrogramModel> dendrogram = new Clustering<DendrogramModel>("Flattened Hierarchical Clustering", "flattened-hierarchical-clustering");
            int i = 0;
            DBIDArrayMIter it2 = this.cluster_leads.iter();
            while (it2.valid()) {
                dendrogram.addToplevelCluster(this.makeCluster(it2, this.clusterHeight.get(i), this.cluster_dbids.get(i)));
                it2.advance();
                ++i;
            }
            this.clusterHeight = null;
            this.cluster_dbids = null;
            it.seek(split);
            while (it.valid()) {
                int clusterid = this.cluster_map.intValue(it);
                if (clusterid < 0) {
                    dendrogram.addToplevelCluster(this.makeCluster(it, Double.NaN, DBIDUtil.deref(it)));
                }
                log.incrementProcessed(progress);
                it.advance();
            }
            this.cluster_map = null;
            return dendrogram;
        }

        private Clustering<DendrogramModel> buildHierarchical(DBIDArrayIter it, int split, FiniteProgress progress) {
            int expcnum = this.ids.size() - split;
            Logging log = AbstractCutDendrogram.this.getLogger();
            Clustering<DendrogramModel> dendrogram = new Clustering<DendrogramModel>("Hierarchical Clustering", "hierarchical-clustering");
            Cluster<DendrogramModel> root = null;
            ArrayList<Cluster<DendrogramModel>> clusters = new ArrayList<Cluster<DendrogramModel>>(expcnum);
            int i = 0;
            DBIDArrayMIter it2 = this.cluster_leads.iter();
            while (it2.valid()) {
                clusters.add(this.makeCluster(it2, this.clusterHeight.get(i), this.cluster_dbids.get(i)));
                it2.advance();
                ++i;
            }
            this.clusterHeight = null;
            this.cluster_dbids = null;
            DBIDVar succ = DBIDUtil.newVar();
            it.seek(split);
            while (it.valid()) {
                int clusterid = this.cluster_map.intValue(it);
                Cluster<DendrogramModel> clus = clusterid >= 0 ? (Cluster<DendrogramModel>)clusters.get(clusterid) : this.makeCluster(it, Double.NaN, DBIDUtil.deref(it));
                this.pi.assignVar(it, succ);
                if (DBIDUtil.equal(it, succ)) {
                    assert (root == null);
                    root = clus;
                    log.incrementProcessed(progress);
                } else {
                    Cluster<DendrogramModel> pclus;
                    int parentid = this.cluster_map.intValue(succ);
                    double depth = this.lambda.doubleValue(it);
                    if (parentid >= 0) {
                        pclus = (Cluster<DendrogramModel>)clusters.get(parentid);
                        if (pclus.getModel().getDistance() == depth) {
                            if (clus == null) {
                                ((ModifiableDBIDs)pclus.getIDs()).add(it);
                            } else {
                                dendrogram.addChildCluster(pclus, clus);
                            }
                        } else {
                            ArrayModifiableDBIDs cids = DBIDUtil.newArray(clus == null ? 1 : 0);
                            if (clus == null) {
                                cids.add(it);
                            }
                            Cluster<DendrogramModel> npclus = this.makeCluster(succ, depth, cids);
                            if (clus != null) {
                                dendrogram.addChildCluster(npclus, clus);
                            }
                            dendrogram.addChildCluster(npclus, pclus);
                            clusters.set(parentid, npclus);
                        }
                    } else {
                        pclus = this.makeCluster(succ, depth, DBIDUtil.EMPTYDBIDS);
                        dendrogram.addChildCluster(pclus, this.makeCluster(succ, Double.NaN, DBIDUtil.deref(succ)));
                        if (clus != null) {
                            dendrogram.addChildCluster(pclus, clus);
                        }
                        parentid = clusters.size();
                        clusters.add(pclus);
                        this.cluster_map.putInt(succ, parentid);
                    }
                    log.incrementProcessed(progress);
                }
                it.advance();
            }
            assert (root != null);
            this.cluster_map = null;
            dendrogram.addToplevelCluster(root);
            return dendrogram;
        }

        protected abstract int findSplit(DBIDArrayIter var1);

        protected Cluster<DendrogramModel> makeCluster(DBIDRef lead, double depth, DBIDs members) {
            String name = members == null || members.size() == 1 && members.contains(lead) ? "obj_" + DBIDUtil.toString(lead) : (members.size() == 0 ? "mrg_" + DBIDUtil.toString(lead) + "_" + depth : (depth < Double.POSITIVE_INFINITY ? "clu_" + DBIDUtil.toString(lead) + "_" + depth : "top_" + DBIDUtil.toString(lead)));
            DendrogramModel model = members != null && !members.isEmpty() && this.pointerresult instanceof PointerPrototypeHierarchyRepresentationResult ? new PrototypeDendrogramModel(depth, ((PointerPrototypeHierarchyRepresentationResult)this.pointerresult).findPrototype(members)) : new DendrogramModel(depth);
            return new Cluster<DendrogramModel>(name, members, model);
        }
    }
}

