/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction;

import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction.AbstractCutDendrogram;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.DendrogramModel;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

public class CutDendrogramByHeight
extends AbstractCutDendrogram
implements ClusteringAlgorithm<Clustering<DendrogramModel>> {
    private static final Logging LOG = Logging.getLogger(CutDendrogramByHeight.class);
    private final double threshold;

    public CutDendrogramByHeight(HierarchicalClusteringAlgorithm algorithm, double threshold, boolean hierarchical) {
        super(algorithm, hierarchical);
        this.threshold = threshold;
    }

    @Override
    public Clustering<DendrogramModel> run(PointerHierarchyRepresentationResult pointerresult) {
        Clustering<DendrogramModel> result = new Instance(pointerresult).extractClusters();
        result.addChildResult(pointerresult);
        return result;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractCutDendrogram.Parameterizer {
        public static final OptionID THRESHOLD_ID = new OptionID("hierarchical.threshold", "The threshold level for which to extract the clusters.");
        double threshold = Double.NaN;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter distP = new DoubleParameter(THRESHOLD_ID);
            if (config.grab(distP)) {
                this.threshold = (Double)distP.getValue();
            }
        }

        @Override
        protected CutDendrogramByHeight makeInstance() {
            return new CutDendrogramByHeight(this.algorithm, this.threshold, this.hierarchical);
        }
    }

    protected class Instance
    extends AbstractCutDendrogram.Instance {
        public Instance(PointerHierarchyRepresentationResult pointerresult) {
            super(pointerresult);
        }

        @Override
        protected int findSplit(DBIDArrayIter it) {
            int split = this.ids.size();
            it.seek(split - 1);
            while (it.valid() && CutDendrogramByHeight.this.threshold <= this.lambda.doubleValue(it)) {
                --split;
                it.retract();
            }
            return split;
        }
    }
}

