/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction;

import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction.AbstractCutDendrogram;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.DendrogramModel;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class CutDendrogramByNumberOfClusters
extends AbstractCutDendrogram
implements ClusteringAlgorithm<Clustering<DendrogramModel>> {
    static final Logging LOG = Logging.getLogger(CutDendrogramByNumberOfClusters.class);
    private final int minclusters;

    public CutDendrogramByNumberOfClusters(HierarchicalClusteringAlgorithm algorithm, int minclusters, boolean hierarchical) {
        super(algorithm, hierarchical);
        this.minclusters = minclusters;
    }

    @Override
    public Clustering<DendrogramModel> run(PointerHierarchyRepresentationResult pointerresult) {
        Clustering<DendrogramModel> result = new Instance(pointerresult).extractClusters();
        result.addChildResult(pointerresult);
        return result;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractCutDendrogram.Parameterizer {
        public static final OptionID MINCLUSTERS_ID = new OptionID("hierarchical.minclusters", "The minimum number of clusters to extract (there may be more clusters when tied, and singletons may be merged into a noise cluster).");
        int minclusters = -1;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter minclustersP = (IntParameter)new IntParameter(MINCLUSTERS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(minclustersP)) {
                this.minclusters = minclustersP.intValue();
            }
        }

        @Override
        protected CutDendrogramByNumberOfClusters makeInstance() {
            return new CutDendrogramByNumberOfClusters(this.algorithm, this.minclusters, this.hierarchical);
        }
    }

    protected class Instance
    extends AbstractCutDendrogram.Instance {
        public Instance(PointerHierarchyRepresentationResult pointerresult) {
            super(pointerresult);
        }

        @Override
        protected int findSplit(DBIDArrayIter it) {
            int split = this.ids.size() > CutDendrogramByNumberOfClusters.this.minclusters ? this.ids.size() - CutDendrogramByNumberOfClusters.this.minclusters : 0;
            it.seek(split);
            double stopdist = this.lambda.doubleValue(it);
            it.retract();
            while (it.valid() && stopdist <= this.lambda.doubleValue(it)) {
                --split;
                it.retract();
            }
            return split;
        }
    }
}

