/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerDensityHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerPrototypeHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.DendrogramModel;
import de.lmu.ifi.dbs.elki.data.model.PrototypeDendrogramModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Collection;

@Reference(authors="R. J. G. B. Campello, D. Moulavi, J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conf. Advances in Knowledge Discovery and Data Mining (PAKDD)", url="https://doi.org/10.1007/978-3-642-37456-2_14", bibkey="DBLP:conf/pakdd/CampelloMS13")
public class HDBSCANHierarchyExtraction
implements ClusteringAlgorithm<Clustering<DendrogramModel>> {
    private static final Logging LOG = Logging.getLogger(HDBSCANHierarchyExtraction.class);
    private int minClSize = 1;
    private HierarchicalClusteringAlgorithm algorithm;
    private boolean hierarchical = true;

    public HDBSCANHierarchyExtraction(HierarchicalClusteringAlgorithm algorithm, int minClSize, boolean hierarchical) {
        this.algorithm = algorithm;
        this.minClSize = minClSize;
        this.hierarchical = hierarchical;
    }

    @Override
    public Clustering<DendrogramModel> run(Database database) {
        PointerHierarchyRepresentationResult pointerresult = this.algorithm.run(database);
        return this.run(pointerresult);
    }

    public Clustering<DendrogramModel> run(PointerHierarchyRepresentationResult pointerresult) {
        Clustering<DendrogramModel> result = new Instance(pointerresult).run();
        result.addChildResult(pointerresult);
        return result;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.algorithm.getInputTypeRestriction();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MINCLUSTERSIZE_ID = new OptionID("hdbscan.minclsize", "The minimum cluster size.");
        public static final OptionID HIERARCHICAL_ID = new OptionID("hdbscan.hierarchical", "Produce a hierarchical output.");
        int minClSize = 1;
        HierarchicalClusteringAlgorithm algorithm;
        boolean hierarchical = true;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag hierarchicalF;
            IntParameter minclustersP;
            super.makeOptions(config);
            ObjectParameter algorithmP = new ObjectParameter(AbstractAlgorithm.ALGORITHM_ID, HierarchicalClusteringAlgorithm.class);
            if (config.grab(algorithmP)) {
                this.algorithm = (HierarchicalClusteringAlgorithm)algorithmP.instantiateClass(config);
            }
            if (config.grab(minclustersP = (IntParameter)new IntParameter(MINCLUSTERSIZE_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minClSize = minclustersP.intValue();
            }
            if (config.grab(hierarchicalF = new Flag(HIERARCHICAL_ID))) {
                this.hierarchical = hierarchicalF.isTrue();
            }
        }

        @Override
        protected HDBSCANHierarchyExtraction makeInstance() {
            return new HDBSCANHierarchyExtraction(this.algorithm, this.minClSize, this.hierarchical);
        }
    }

    private static class TempCluster {
        protected ModifiableDBIDs members = DBIDUtil.newArray();
        protected double dist = 0.0;
        protected double aggregate = 0.0;
        protected int childrenTotal = 0;
        protected Collection<TempCluster> children = new ArrayList<TempCluster>();

        public TempCluster(double dist, DBIDRef a) {
            this.dist = dist;
            this.members.add(a);
            this.aggregate = 1.0 / dist;
        }

        public TempCluster(double dist, DBIDRef a, DBIDRef b) {
            this.dist = dist;
            this.members.add(a);
            this.members.add(b);
            this.aggregate = 2.0 / dist;
        }

        public TempCluster(double dist, TempCluster a, TempCluster b) {
            this.dist = dist;
            this.children.add(a);
            this.children.add(b);
            this.childrenTotal = a.totalElements() + b.totalElements();
            this.aggregate = (double)this.childrenTotal / dist;
        }

        public TempCluster grow(double dist, TempCluster other, DBIDRef id) {
            this.dist = dist;
            if (other == null) {
                this.members.add(id);
                this.aggregate += 1.0 / dist;
            } else {
                assert (other.children.isEmpty());
                this.members.addDBIDs(other.members);
                this.aggregate += (double)other.members.size() / dist;
                other.members = null;
                other.children = null;
            }
            return this;
        }

        public TempCluster resetAggregate() {
            this.aggregate = (double)this.totalElements() / this.dist;
            return this;
        }

        public int totalElements() {
            return this.childrenTotal + this.members.size();
        }

        public double excessOfMass() {
            return this.aggregate - (double)this.totalElements() / this.dist;
        }

        public double totalStability() {
            double stability = this.excessOfMass();
            double cstab = 0.0;
            for (TempCluster child : this.children) {
                cstab += Math.abs(child.totalStability());
            }
            return stability > cstab ? stability : -cstab;
        }

        public boolean isSpurious(int minClSize) {
            return this.children.isEmpty() && this.members.size() < minClSize;
        }
    }

    protected class Instance {
        protected ArrayDBIDs ids;
        protected DBIDDataStore pi;
        protected DoubleDataStore lambda;
        protected DoubleDataStore coredist = null;
        protected PointerHierarchyRepresentationResult pointerresult;

        public Instance(PointerHierarchyRepresentationResult pointerresult) {
            this.ids = pointerresult.topologicalSort();
            this.pi = pointerresult.getParentStore();
            this.lambda = pointerresult.getParentDistanceStore();
            this.pointerresult = pointerresult;
            if (pointerresult instanceof PointerDensityHierarchyRepresentationResult) {
                this.coredist = ((PointerDensityHierarchyRepresentationResult)pointerresult).getCoreDistanceStore();
            }
        }

        public Clustering<DendrogramModel> run() {
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Extracting clusters", this.ids.size(), LOG) : null;
            ArrayDBIDs order = this.pointerresult.topologicalSort();
            WritableDataStore<TempCluster> cluster_map = DataStoreUtil.makeStorage(this.ids, 1, TempCluster.class);
            ArrayModifiableDBIDs noise = DBIDUtil.newArray();
            ArrayList<TempCluster> toplevel = new ArrayList<TempCluster>();
            DBIDVar olead = DBIDUtil.newVar();
            DBIDArrayIter clead = order.iter();
            while (clead.valid()) {
                double dist = this.lambda.doubleValue(clead);
                double cdist = this.coredist != null ? this.coredist.doubleValue(clead) : dist;
                TempCluster cclus = (TempCluster)cluster_map.get(clead);
                cluster_map.put(clead, null);
                boolean cSpurious = this.isSpurious(cclus, cdist <= dist);
                this.pi.assignVar(clead, olead);
                if (DBIDUtil.equal(clead, olead) || olead.isEmpty()) {
                    if (cclus != null) {
                        if (cclus.isSpurious(HDBSCANHierarchyExtraction.this.minClSize)) {
                            noise.addDBIDs(cclus.members);
                        } else {
                            toplevel.add(cclus);
                        }
                        cluster_map.put(clead, null);
                    } else if (cSpurious) {
                        noise.add(clead);
                    } else {
                        toplevel.add(new TempCluster(dist, clead));
                    }
                    LOG.incrementProcessed(progress);
                } else {
                    TempCluster nclus;
                    double odist;
                    TempCluster oclus = (TempCluster)cluster_map.get(olead);
                    boolean oSpurious = this.isSpurious(oclus, (odist = this.coredist != null ? this.coredist.doubleValue(olead) : dist) <= dist);
                    if (!oSpurious && !cSpurious) {
                        cclus = cclus != null ? cclus : new TempCluster(cdist, clead);
                        oclus = oclus != null ? oclus : new TempCluster(odist, olead);
                        nclus = new TempCluster(dist, oclus, cclus);
                    } else {
                        nclus = !oSpurious && oclus != null ? oclus.grow(dist, cclus, clead) : (!cSpurious && cclus != null ? cclus.grow(dist, oclus, olead) : (oclus != null ? oclus.grow(dist, cclus, clead).resetAggregate() : (cclus != null ? cclus.grow(dist, oclus, olead).resetAggregate() : new TempCluster(dist, clead, olead))));
                    }
                    assert (nclus != null);
                    cluster_map.put(olead, nclus);
                    LOG.incrementProcessed(progress);
                }
                clead.advance();
            }
            LOG.ensureCompleted(progress);
            Clustering<DendrogramModel> dendrogram = new Clustering<DendrogramModel>("Hierarchical Clustering", "hierarchical-clustering");
            Cluster<DendrogramModel> nclus = null;
            if (noise.size() > 0) {
                nclus = new Cluster<DendrogramModel>("Noise", noise, true, new DendrogramModel(Double.POSITIVE_INFINITY));
                dendrogram.addToplevelCluster(nclus);
            }
            for (TempCluster clus : toplevel) {
                this.finalizeCluster(clus, dendrogram, nclus, false);
            }
            return dendrogram;
        }

        private boolean isSpurious(TempCluster clus, boolean isCore) {
            return clus != null ? clus.isSpurious(HDBSCANHierarchyExtraction.this.minClSize) : HDBSCANHierarchyExtraction.this.minClSize > 1 || !isCore;
        }

        private void finalizeCluster(TempCluster temp, Clustering<DendrogramModel> clustering, Cluster<DendrogramModel> parent, boolean flatten) {
            String name = "C_" + FormatUtil.NF6.format(temp.dist);
            DendrogramModel model = temp.members != null && !temp.members.isEmpty() && this.pointerresult instanceof PointerPrototypeHierarchyRepresentationResult ? new PrototypeDendrogramModel(temp.dist, ((PointerPrototypeHierarchyRepresentationResult)this.pointerresult).findPrototype(temp.members)) : new DendrogramModel(temp.dist);
            Cluster<DendrogramModel> clus = new Cluster<DendrogramModel>(name, (DBIDs)temp.members, model);
            if (HDBSCANHierarchyExtraction.this.hierarchical && parent != null) {
                clustering.addChildCluster(parent, clus);
            } else {
                clustering.addToplevelCluster(clus);
            }
            this.collectChildren(temp, clustering, temp, clus, flatten);
            temp.members = null;
            temp.children = null;
        }

        private void collectChildren(TempCluster temp, Clustering<DendrogramModel> clustering, TempCluster cur, Cluster<DendrogramModel> clus, boolean flatten) {
            for (TempCluster child : cur.children) {
                if (flatten || child.totalStability() < 0.0) {
                    temp.members.addDBIDs(child.members);
                    this.collectChildren(temp, clustering, child, clus, flatten);
                    continue;
                }
                this.finalizeCluster(child, clustering, clus, true);
            }
        }
    }
}

