/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerDensityHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerPrototypeHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.DendrogramModel;
import de.lmu.ifi.dbs.elki.data.model.PrototypeDendrogramModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Collection;

@Reference(authors="R. J. G. B. Campello, D. Moulavi, J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conf. Advances in Knowledge Discovery and Data Mining (PAKDD)", url="https://doi.org/10.1007/978-3-642-37456-2_14", bibkey="DBLP:conf/pakdd/CampelloMS13")
@Priority(value=205)
public class SimplifiedHierarchyExtraction
implements ClusteringAlgorithm<Clustering<DendrogramModel>> {
    private static final Logging LOG = Logging.getLogger(SimplifiedHierarchyExtraction.class);
    private int minClSize = 1;
    private HierarchicalClusteringAlgorithm algorithm;

    public SimplifiedHierarchyExtraction(HierarchicalClusteringAlgorithm algorithm, int minClSize) {
        this.algorithm = algorithm;
        this.minClSize = minClSize;
    }

    @Override
    public Clustering<DendrogramModel> run(Database database) {
        PointerHierarchyRepresentationResult pointerresult = this.algorithm.run(database);
        return this.run(pointerresult);
    }

    public Clustering<DendrogramModel> run(PointerHierarchyRepresentationResult pointerresult) {
        Clustering<DendrogramModel> result = new Instance(pointerresult).run();
        result.addChildResult(pointerresult);
        return result;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.algorithm.getInputTypeRestriction();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MINCLUSTERSIZE_ID = new OptionID("hdbscan.minclsize", "The minimum cluster size.");
        int minClSize = 1;
        HierarchicalClusteringAlgorithm algorithm;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter minclustersP;
            super.makeOptions(config);
            ObjectParameter algorithmP = new ObjectParameter(AbstractAlgorithm.ALGORITHM_ID, HierarchicalClusteringAlgorithm.class);
            if (config.grab(algorithmP)) {
                this.algorithm = (HierarchicalClusteringAlgorithm)algorithmP.instantiateClass(config);
            }
            if (config.grab(minclustersP = (IntParameter)new IntParameter(MINCLUSTERSIZE_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minClSize = minclustersP.intValue();
            }
        }

        @Override
        protected SimplifiedHierarchyExtraction makeInstance() {
            return new SimplifiedHierarchyExtraction(this.algorithm, this.minClSize);
        }
    }

    private static class TempCluster {
        protected ModifiableDBIDs newids = DBIDUtil.newArray();
        protected double depth = 0.0;
        protected Collection<Cluster<DendrogramModel>> children = new ArrayList<Cluster<DendrogramModel>>();

        public TempCluster(double depth) {
            this.depth = depth;
        }

        public void add(DBIDRef id) {
            this.newids.add(id);
        }

        public void addDBIDs(DBIDs ids) {
            this.newids.addDBIDs(ids);
        }

        public void addChild(Cluster<DendrogramModel> clu) {
            this.children.add(clu);
        }

        public boolean isNotSpurious(int minClSize) {
            return !this.children.isEmpty() || this.newids.size() >= minClSize;
        }
    }

    protected class Instance {
        protected ArrayDBIDs ids;
        protected DBIDDataStore pi;
        protected DoubleDataStore lambda;
        protected DoubleDataStore coredist = null;
        protected PointerHierarchyRepresentationResult pointerresult;

        public Instance(PointerHierarchyRepresentationResult pointerresult) {
            this.ids = pointerresult.topologicalSort();
            this.pi = pointerresult.getParentStore();
            this.lambda = pointerresult.getParentDistanceStore();
            this.pointerresult = pointerresult;
            if (pointerresult instanceof PointerDensityHierarchyRepresentationResult) {
                this.coredist = ((PointerDensityHierarchyRepresentationResult)pointerresult).getCoreDistanceStore();
            }
        }

        public Clustering<DendrogramModel> run() {
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Extracting clusters", this.ids.size(), LOG) : null;
            ArrayDBIDs order = this.pointerresult.topologicalSort();
            WritableDataStore<TempCluster> cluster_map = DataStoreUtil.makeStorage(this.ids, 1, TempCluster.class);
            ArrayModifiableDBIDs noise = DBIDUtil.newArray();
            ArrayList<Cluster<DendrogramModel>> toplevel = new ArrayList<Cluster<DendrogramModel>>();
            Clustering<DendrogramModel> dendrogram = new Clustering<DendrogramModel>("Hierarchical Clustering", "hierarchical-clustering");
            DBIDVar succ = DBIDUtil.newVar();
            DBIDArrayIter it = order.iter();
            while (it.valid()) {
                double d = this.lambda.doubleValue(it);
                boolean cIsCore = this.coredist == null || d >= this.coredist.doubleValue(it);
                TempCluster cclus = (TempCluster)cluster_map.get(it);
                boolean cNotSpurious = cclus != null ? cclus.isNotSpurious(SimplifiedHierarchyExtraction.this.minClSize) : SimplifiedHierarchyExtraction.this.minClSize <= 1 && cIsCore;
                this.pi.assignVar(it, succ);
                if (DBIDUtil.equal(it, succ)) {
                    if (cclus != null) {
                        if (cclus.isNotSpurious(SimplifiedHierarchyExtraction.this.minClSize)) {
                            toplevel.add(this.toCluster(cclus, dendrogram, it));
                        } else {
                            noise.addDBIDs(cclus.newids);
                        }
                        cluster_map.put(it, null);
                    } else if (SimplifiedHierarchyExtraction.this.minClSize <= 1 && cIsCore) {
                        toplevel.add(this.makeCluster(it, d, null));
                    } else {
                        noise.add(it);
                    }
                    LOG.incrementProcessed(progress);
                } else {
                    boolean oNotSpurious;
                    boolean oIsCore;
                    TempCluster oclus = (TempCluster)cluster_map.get(succ);
                    boolean bl = oIsCore = this.coredist == null || d <= this.coredist.doubleValue(succ);
                    boolean bl2 = oclus != null ? oclus.isNotSpurious(SimplifiedHierarchyExtraction.this.minClSize) : (oNotSpurious = SimplifiedHierarchyExtraction.this.minClSize <= 1 && oIsCore);
                    if (oclus != null && cclus != null) {
                        if (oNotSpurious && cNotSpurious) {
                            oclus.addChild(this.toCluster(oclus, dendrogram, it));
                            oclus.addChild(this.toCluster(cclus, dendrogram, it));
                            assert (oclus.children.size() == 2);
                            oclus.depth = d;
                        } else if (cNotSpurious) {
                            cclus.addDBIDs(oclus.newids);
                            assert (oclus.children.isEmpty());
                            cclus.depth = d;
                            cluster_map.put(succ, cclus);
                        } else {
                            oclus.addDBIDs(cclus.newids);
                            assert (cclus.children.isEmpty());
                            oclus.depth = d;
                        }
                    } else if (cclus != null) {
                        if (cNotSpurious && oNotSpurious) {
                            cclus.addChild(this.toCluster(cclus, dendrogram, it));
                        }
                        this.addSingleton(cclus, succ, d, oNotSpurious);
                        cluster_map.put(succ, cclus);
                    } else if (oclus != null) {
                        if (cNotSpurious && oNotSpurious) {
                            oclus.addChild(this.toCluster(oclus, dendrogram, it));
                        }
                        this.addSingleton(oclus, it, d, cNotSpurious);
                    } else {
                        oclus = new TempCluster(d);
                        this.addSingleton(oclus, it, d, cNotSpurious);
                        this.addSingleton(oclus, succ, d, oNotSpurious);
                        cluster_map.put(succ, oclus);
                    }
                    cluster_map.put(it, null);
                    LOG.incrementProcessed(progress);
                }
                it.advance();
            }
            LOG.ensureCompleted(progress);
            if (noise.size() > 0) {
                Cluster<DendrogramModel> nclus = new Cluster<DendrogramModel>("Noise", noise, true, new DendrogramModel(Double.POSITIVE_INFINITY));
                dendrogram.addToplevelCluster(nclus);
                for (Cluster cluster : toplevel) {
                    dendrogram.addChildCluster(nclus, cluster);
                }
            } else {
                for (Cluster cluster : toplevel) {
                    dendrogram.addToplevelCluster(cluster);
                }
            }
            return dendrogram;
        }

        private void addSingleton(TempCluster clus, DBIDRef id, double dist, boolean asCluster) {
            if (asCluster) {
                clus.addChild(this.makeCluster(id, dist, null));
            } else {
                clus.add(id);
            }
            clus.depth = dist;
        }

        protected Cluster<DendrogramModel> toCluster(TempCluster temp, Clustering<DendrogramModel> clustering, DBIDRef lead) {
            Cluster<DendrogramModel> cluster = this.makeCluster(lead, temp.depth, DBIDUtil.newArray(temp.newids));
            for (Cluster<DendrogramModel> child : temp.children) {
                clustering.addChildCluster(cluster, child);
            }
            temp.newids.clear();
            temp.children.clear();
            return cluster;
        }

        protected Cluster<DendrogramModel> makeCluster(DBIDRef lead, double depth, DBIDs members) {
            String name;
            if (members == null || members.size() == 1 && members.contains(lead)) {
                name = "obj_" + DBIDUtil.toString(lead);
                if (members == null) {
                    ArrayModifiableDBIDs m = DBIDUtil.newArray(1);
                    m.add(lead);
                    members = m;
                }
            } else {
                name = members.size() == 0 ? "mrg_" + DBIDUtil.toString(lead) + "_" + depth : (depth < Double.POSITIVE_INFINITY ? "clu_" + DBIDUtil.toString(lead) + "_" + depth : "top_" + DBIDUtil.toString(lead));
            }
            DendrogramModel model = members != null && !members.isEmpty() && this.pointerresult instanceof PointerPrototypeHierarchyRepresentationResult ? new PrototypeDendrogramModel(depth, ((PointerPrototypeHierarchyRepresentationResult)this.pointerresult).findPrototype(members)) : new DendrogramModel(depth);
            return new Cluster<DendrogramModel>(name, members, model);
        }
    }
}

