/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage.Linkage;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J. C. Gower", title="A comparison of some methods of cluster analysis", booktitle="Biometrics (1967)", url="https://doi.org/10.2307/2528417", bibkey="doi:10.2307/2528417")
@Alias(value={"centroid", "upgmc", "de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.CentroidLinkageMethod"})
public class CentroidLinkage
implements Linkage {
    public static final CentroidLinkage STATIC = new CentroidLinkage();

    @Deprecated
    public CentroidLinkage() {
    }

    @Override
    public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
        double f = 1.0 / (double)(sizex + sizey);
        return ((double)sizex * dx + (double)sizey * dy - (double)(sizex * sizey) * f * dxy) * f;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected CentroidLinkage makeInstance() {
            return STATIC;
        }
    }
}

