/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage.Linkage;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GreaterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Reference(authors="G. N. Lance, W. T. Williams", title="A general theory of classificatory sorting strategies 1. Hierarchical systems", booktitle="The Computer Journal 9.4", url="https://doi.org/10.1093/comjnl/9.4.373", bibkey="doi:10.1093/comjnl/9.4.373")
@Alias(value={"flex", "beta", "de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.FlexibleBetaLinkageMethod"})
@Priority(value=-2)
public class FlexibleBetaLinkage
implements Linkage {
    double alpha;
    double beta;

    public FlexibleBetaLinkage(double beta) {
        this.alpha = 0.5 * (1.0 - beta);
        this.beta = beta;
    }

    @Override
    public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
        return this.alpha * dx + this.alpha * dy + this.beta * dxy;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID BETA_ID = new OptionID("lancewilliams.beta", "Beta for the Lance-Williams flexible beta approach.");
        double beta;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter betaP = (DoubleParameter)((DoubleParameter)new DoubleParameter(BETA_ID, -0.25).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE)).addConstraint((ParameterConstraint)new GreaterConstraint(-1.0));
            if (config.grab(betaP)) {
                this.beta = betaP.doubleValue();
            }
        }

        @Override
        protected FlexibleBetaLinkage makeInstance() {
            return new FlexibleBetaLinkage(this.beta);
        }
    }
}

