/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage.Linkage;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@References(value={@Reference(authors="J. Podani", title="New Combinatorial Clustering Methods", booktitle="Vegetatio 81(1/2)", url="https://doi.org/10.1007/978-94-009-2432-1_5", bibkey="doi:10.1007/978-94-009-2432-1_5"), @Reference(authors="E. Diday, J. Lemaire, J. Pouget, F. Testu", title="Elements d'analyse de donnees", booktitle="", bibkey="books/misc/DidayLPT85")})
@Alias(value={"variance", "de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.MinimumVarianceLinkageMethod"})
public class MinimumVarianceLinkage
implements Linkage {
    public static final MinimumVarianceLinkage STATIC = new MinimumVarianceLinkage();

    @Deprecated
    public MinimumVarianceLinkage() {
    }

    @Override
    public double initial(double d, boolean issquare) {
        return 0.25 * (issquare ? d : d * d);
    }

    @Override
    public double restore(double d, boolean issquare) {
        return issquare ? 4.0 * d : FastMath.sqrt(4.0 * d);
    }

    @Override
    public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
        int xj = sizex + sizej;
        int yj = sizey + sizej;
        int n = sizex + sizey + sizej;
        return ((double)xj * (double)xj * dx + (double)yj * (double)yj * dy - (double)sizej * (double)(sizex + sizey) * dxy) / ((double)n * (double)n);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MinimumVarianceLinkage makeInstance() {
            return STATIC;
        }
    }
}

