/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.linkage.Linkage;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import net.jafama.FastMath;

@References(value={@Reference(authors="J. H. Ward Jr.", title="Hierarchical grouping to optimize an objective function", booktitle="Journal of the American statistical association 58.301", url="https://doi.org/10.1080/01621459.1963.10500845", bibkey="doi:10.1080/01621459.1963.10500845"), @Reference(authors="D. Wishart", title="256. Note: An Algorithm for Hierarchical Classifications", booktitle="BBiometrics 25(1)", url="https://doi.org/10.2307/2528688", bibkey="doi:10.2307/2528688")})
@Alias(value={"ward", "MISSQ", "de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.WardLinkageMethod"})
@Priority(value=101)
public class WardLinkage
implements Linkage {
    public static final WardLinkage STATIC = new WardLinkage();

    @Deprecated
    public WardLinkage() {
    }

    @Override
    public double initial(double d, boolean issquare) {
        return 0.5 * (issquare ? d : d * d);
    }

    @Override
    public double restore(double d, boolean issquare) {
        return issquare ? 2.0 * d : FastMath.sqrt(2.0 * d);
    }

    @Override
    public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
        return ((double)(sizex + sizej) * dx + (double)(sizey + sizej) * dy - (double)sizej * dxy) / (double)(sizex + sizey + sizej);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected WardLinkage makeInstance() {
            return STATIC;
        }
    }
}

