/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality.KMeansQualityMeasure;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class BestOfMultipleKMeans<V extends NumberVector, M extends MeanModel>
extends AbstractAlgorithm<Clustering<M>>
implements KMeans<V, M> {
    private static final Logging LOG = Logging.getLogger(BestOfMultipleKMeans.class);
    private int trials;
    private KMeans<V, M> innerkMeans;
    private KMeansQualityMeasure<? super V> qualityMeasure;

    public BestOfMultipleKMeans(int trials, KMeans<V, M> innerkMeans, KMeansQualityMeasure<? super V> qualityMeasure) {
        this.trials = trials;
        this.innerkMeans = innerkMeans;
        this.qualityMeasure = qualityMeasure;
    }

    @Override
    public Clustering<M> run(Database database, Relation<V> relation) {
        if (!(this.innerkMeans.getDistanceFunction() instanceof PrimitiveDistanceFunction)) {
            throw new AbortException("K-Means results can only be evaluated for primitive distance functions, got: " + this.innerkMeans.getDistanceFunction().getClass());
        }
        NumberVectorDistanceFunction df = (NumberVectorDistanceFunction)this.innerkMeans.getDistanceFunction();
        Clustering<M> bestResult = null;
        double bestCost = Double.NaN;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("K-means iterations", this.trials, LOG) : null;
        for (int i = 0; i < this.trials; ++i) {
            Clustering<M> currentCandidate = this.innerkMeans.run(database, relation);
            double currentCost = this.qualityMeasure.quality(currentCandidate, df, relation);
            LOG.verbose("Cost of candidate " + i + ": " + currentCost);
            if (this.qualityMeasure.isBetter(currentCost, bestCost)) {
                bestResult = currentCandidate;
                bestCost = currentCost;
            }
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        return bestResult;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.innerkMeans.getInputTypeRestriction();
    }

    @Override
    public DistanceFunction<? super V> getDistanceFunction() {
        return this.innerkMeans.getDistanceFunction();
    }

    @Override
    public void setK(int k) {
        this.innerkMeans.setK(k);
    }

    @Override
    public void setDistanceFunction(NumberVectorDistanceFunction<? super V> distanceFunction) {
        this.innerkMeans.setDistanceFunction(distanceFunction);
    }

    @Override
    public void setInitializer(KMeansInitialization init) {
        this.innerkMeans.setInitializer(init);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector, M extends MeanModel>
    extends AbstractParameterizer {
        public static final OptionID TRIALS_ID = new OptionID("kmeans.trials", "The number of trials to run.");
        public static final OptionID KMEANS_ID = new OptionID("kmeans.algorithm", "KMeans variant to run multiple times.");
        public static final OptionID QUALITYMEASURE_ID = new OptionID("kmeans.qualitymeasure", "Quality measure variant for deciding which run to keep.");
        protected int trials;
        protected KMeans<V, M> kMeansVariant;
        protected KMeansQualityMeasure<? super V> qualityMeasure;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter qualityMeasureP;
            ObjectParameter kMeansVariantP;
            IntParameter trialsP = (IntParameter)new IntParameter(TRIALS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(trialsP)) {
                this.trials = trialsP.intValue();
            }
            if (config.grab(kMeansVariantP = new ObjectParameter(KMEANS_ID, KMeans.class))) {
                this.kMeansVariant = (KMeans)kMeansVariantP.instantiateClass(config);
            }
            if (config.grab(qualityMeasureP = new ObjectParameter(QUALITYMEASURE_ID, KMeansQualityMeasure.class))) {
                this.qualityMeasure = (KMeansQualityMeasure)qualityMeasureP.instantiateClass(config);
            }
        }

        @Override
        protected BestOfMultipleKMeans<V, M> makeInstance() {
            return new BestOfMultipleKMeans<V, M>(this.trials, this.kMeansVariant, this.qualityMeasure);
        }
    }
}

