/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithmUtil;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

@Reference(authors="R. T. Ng, J. Han", title="CLARANS: a method for clustering objects for spatial data mining", booktitle="IEEE Transactions on Knowledge and Data Engineering 14(5)", url="https://doi.org/10.1109/TKDE.2002.1033770", bibkey="DBLP:journals/tkde/NgH02")
public class CLARANS<V>
extends AbstractDistanceBasedAlgorithm<V, Clustering<MedoidModel>>
implements ClusteringAlgorithm<Clustering<MedoidModel>> {
    private static final Logging LOG = Logging.getLogger(CLARANS.class);
    int k;
    int numlocal;
    double maxneighbor;
    RandomFactory random;

    public CLARANS(DistanceFunction<? super V> distanceFunction, int k, int numlocal, double maxneighbor, RandomFactory random) {
        super(distanceFunction);
        this.k = k;
        this.numlocal = numlocal;
        this.maxneighbor = maxneighbor;
        this.random = random;
    }

    public Clustering<MedoidModel> run(Database database, Relation<V> relation) {
        if (relation.size() <= 0) {
            return new Clustering<MedoidModel>("CLARANS Clustering", "clarans-clustering");
        }
        if (this.k * 2 >= relation.size()) {
            LOG.warning("A very large k was chosen. This implementation is not optimized for this case.");
        }
        DBIDs ids = relation.getDBIDs();
        DistanceQuery<V> distQ = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        boolean metric = this.getDistanceFunction().isMetric();
        int retries = (int)Math.ceil(this.maxneighbor < 1.0 ? this.maxneighbor * (double)this.k * (double)(ids.size() - this.k) : this.maxneighbor);
        Random rnd = this.random.getSingleThreadedRandom();
        DBIDArrayIter cand = DBIDUtil.ensureArray(ids).iter();
        Assignment best = new Assignment(distQ, ids, this.k);
        Assignment curr = new Assignment(distQ, ids, this.k);
        Assignment scratch = new Assignment(distQ, ids, this.k);
        double bestscore = Double.POSITIVE_INFINITY;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("CLARANS sampling restarts", this.numlocal, LOG) : null;
        for (int i = 0; i < this.numlocal; ++i) {
            curr.medoids.clear();
            curr.medoids.addDBIDs(DBIDUtil.randomSample(ids, this.k, rnd));
            double total = curr.assignToNearestCluster();
            int j = 1;
            block1: while (j < retries) {
                int otherm;
                double cost;
                int r = 0;
                while (true) {
                    cand.seek(rnd.nextInt(ids.size()));
                    if (curr.nearest.doubleValue(cand) > 0.0) break;
                    if (metric && curr.second.doubleValue(cand) == 0.0) {
                        ++j;
                        continue block1;
                    }
                    if (!metric && !curr.medoids.contains(cand)) break;
                    if (r >= 1000) {
                        throw new AbortException("Failed to choose a non-medoid in 1000 attempts. Choose k << N.");
                    }
                    ++r;
                }
                if (!((cost = curr.computeCostDifferential(cand, otherm = rnd.nextInt(this.k), scratch)) < -1.0E-12 * total)) {
                    ++j;
                    continue;
                }
                total += cost;
                Assignment tmp = curr;
                curr = scratch;
                scratch = tmp;
                j = 1;
            }
            if (LOG.isStatistics()) {
                LOG.statistics(new DoubleStatistic(this.getClass().getName() + ".sample-" + i + ".cost", total));
            }
            if (total < bestscore) {
                Assignment tmp = curr;
                curr = best;
                best = tmp;
                bestscore = total;
            }
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        if (LOG.isStatistics()) {
            LOG.statistics(new DoubleStatistic(this.getClass().getName() + ".cost", bestscore));
        }
        ArrayModifiableDBIDs[] clusters = ClusteringAlgorithmUtil.partitionsFromIntegerLabels(ids, best.assignment, this.k);
        Clustering<MedoidModel> result = new Clustering<MedoidModel>("CLARANS Clustering", "clarans-clustering");
        DBIDArrayMIter it = best.medoids.iter();
        while (it.valid()) {
            result.addToplevelCluster(new Cluster<MedoidModel>((DBIDs)clusters[it.getOffset()], new MedoidModel(DBIDUtil.deref(it))));
            it.advance();
        }
        return result;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID RESTARTS_ID = new OptionID("clara.numlocal", "Number of samples (restarts) to run.");
        public static final OptionID NEIGHBORS_ID = new OptionID("clara.numneighbor", "Number of tries to find a neighbor.");
        public static final OptionID RANDOM_ID = new OptionID("clarans.random", "Random generator seed.");
        double maxneighbor;
        int numlocal;
        int k;
        RandomFactory random;

        protected double defaultRate() {
            return 0.0125;
        }

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter randomP;
            DoubleParameter maxneighborP;
            IntParameter numlocalP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(KMeans.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
            if (config.grab(numlocalP = (IntParameter)new IntParameter(RESTARTS_ID, 2).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.numlocal = numlocalP.intValue();
            }
            if (config.grab(maxneighborP = (DoubleParameter)new DoubleParameter(NEIGHBORS_ID, this.defaultRate()).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.maxneighbor = maxneighborP.doubleValue();
            }
            if (config.grab(randomP = new RandomParameter(RANDOM_ID))) {
                this.random = (RandomFactory)randomP.getValue();
            }
        }

        @Override
        protected CLARANS<V> makeInstance() {
            return new CLARANS(this.distanceFunction, this.k, this.numlocal, this.maxneighbor, this.random);
        }
    }

    protected static class Assignment {
        DBIDs ids;
        DistanceQuery<?> distQ;
        WritableDoubleDataStore nearest;
        WritableDoubleDataStore second;
        WritableIntegerDataStore assignment;
        WritableIntegerDataStore secondid;
        ArrayModifiableDBIDs medoids;
        DBIDArrayMIter miter;

        public Assignment(DistanceQuery<?> distQ, DBIDs ids, int k) {
            this.distQ = distQ;
            this.ids = ids;
            this.medoids = DBIDUtil.newArray(k);
            this.miter = this.medoids.iter();
            this.assignment = DataStoreUtil.makeIntegerStorage(ids, 3, -1);
            this.nearest = DataStoreUtil.makeDoubleStorage(ids, 3);
            this.secondid = DataStoreUtil.makeIntegerStorage(ids, 3, -1);
            this.second = DataStoreUtil.makeDoubleStorage(ids, 3);
        }

        protected double computeCostDifferential(DBIDRef h, int mnum, Assignment scratch) {
            scratch.medoids.clear();
            scratch.medoids.addDBIDs(this.medoids);
            scratch.medoids.set(mnum, h);
            double cost = 0.0;
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                if (DBIDUtil.equal(h, j)) {
                    scratch.recompute(j, mnum, 0.0, -1, Double.POSITIVE_INFINITY);
                } else {
                    double distcur = this.nearest.doubleValue(j);
                    double dist_h = this.distQ.distance(h, (DBIDRef)j);
                    int jcur = this.assignment.intValue(j);
                    if (jcur == mnum) {
                        double distsec = this.second.doubleValue(j);
                        if (dist_h < distsec) {
                            cost += dist_h - distcur;
                            scratch.assignment.putInt(j, mnum);
                            scratch.nearest.putDouble(j, dist_h);
                            scratch.second.putDouble(j, distsec);
                            scratch.secondid.putInt(j, jcur);
                        } else {
                            cost += distsec - distcur;
                            scratch.recompute(j, mnum, dist_h, jcur, distsec);
                        }
                    } else if (dist_h < distcur) {
                        cost += dist_h - distcur;
                        scratch.assignment.putInt(j, mnum);
                        scratch.nearest.putDouble(j, dist_h);
                        scratch.second.putDouble(j, distcur);
                        scratch.secondid.putInt(j, jcur);
                    } else {
                        int jsec = this.secondid.intValue(j);
                        double distsec = this.second.doubleValue(j);
                        if (jsec != mnum && distsec <= dist_h) {
                            scratch.assignment.putInt(j, jcur);
                            scratch.nearest.putDouble(j, distcur);
                            scratch.secondid.putInt(j, jsec);
                            scratch.second.putDouble(j, distsec);
                        } else {
                            scratch.recompute(j, jcur, distcur, mnum, dist_h);
                        }
                    }
                }
                j.advance();
            }
            return cost;
        }

        protected double recompute(DBIDRef id, int mnum, double known, int snum, double sknown) {
            double mindist = mnum >= 0 ? known : Double.POSITIVE_INFINITY;
            double mindist2 = Double.POSITIVE_INFINITY;
            int minIndex = mnum;
            int minIndex2 = -1;
            int i = 0;
            while (this.miter.seek(i).valid()) {
                if (i != mnum) {
                    double dist;
                    double d = dist = i == snum ? sknown : this.distQ.distance(id, (DBIDRef)this.miter);
                    if (DBIDUtil.equal(id, this.miter) || dist < mindist) {
                        minIndex2 = minIndex;
                        mindist2 = mindist;
                        minIndex = i;
                        mindist = dist;
                    } else if (dist < mindist2) {
                        minIndex2 = i;
                        mindist2 = dist;
                    }
                }
                ++i;
            }
            if (minIndex < 0) {
                throw new AbortException("Too many infinite distances. Cannot assign objects.");
            }
            this.assignment.putInt(id, minIndex);
            this.nearest.putDouble(id, mindist);
            this.secondid.putInt(id, minIndex2);
            this.second.putDouble(id, mindist2);
            return mindist;
        }

        protected double assignToNearestCluster() {
            double cost = 0.0;
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                cost += this.recompute(iditer, -1, Double.POSITIVE_INFINITY, -1, Double.POSITIVE_INFINITY);
                iditer.advance();
            }
            return cost;
        }
    }
}

