/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithmUtil;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.CLARANS;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Arrays;
import java.util.Random;

@Reference(authors="Erich Schubert, Peter J. Rousseeuw", title="Faster k-Medoids Clustering: Improving the PAM, CLARA, and CLARANS Algorithms", booktitle="preprint, to appear", url="https://arxiv.org/abs/1810.05691", bibkey="DBLP:journals/corr/abs-1810-05691")
@Priority(value=101)
public class FastCLARANS<V>
extends CLARANS<V> {
    private static final Logging LOG = Logging.getLogger(FastCLARANS.class);

    public FastCLARANS(DistanceFunction<? super V> distanceFunction, int k, int numlocal, double maxneighbor, RandomFactory random) {
        super(distanceFunction, k, numlocal, maxneighbor, random);
    }

    @Override
    public Clustering<MedoidModel> run(Database database, Relation<V> relation) {
        if (relation.size() <= 0) {
            return new Clustering<MedoidModel>("CLARANS Clustering", "clarans-clustering");
        }
        if (this.k * 2 >= relation.size()) {
            LOG.warning("A very large k was chosen. This implementation is not optimized for this case.");
        }
        DBIDs ids = relation.getDBIDs();
        DistanceQuery<V> distQ = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        boolean metric = this.getDistanceFunction().isMetric();
        int retries = (int)Math.ceil(this.maxneighbor < 1.0 ? this.maxneighbor * (double)(ids.size() - this.k) : this.maxneighbor);
        Random rnd = this.random.getSingleThreadedRandom();
        ArrayModifiableDBIDs subsampler = DBIDUtil.newArray(ids);
        DBIDArrayMIter cand = subsampler.iter();
        Assignment best = new Assignment(distQ, ids, this.k);
        Assignment curr = new Assignment(distQ, ids, this.k);
        double bestscore = Double.POSITIVE_INFINITY;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("CLARANS sampling restarts", this.numlocal, LOG) : null;
        for (int i = 0; i < this.numlocal; ++i) {
            curr.medoids.clear();
            curr.medoids.addDBIDs(DBIDUtil.randomSample(ids, this.k, rnd));
            double total = curr.assignToNearestCluster();
            int j = 1;
            block1: while (j < retries) {
                double cost;
                for (int r = 0; r < ids.size(); ++r) {
                    subsampler.swap(r, rnd.nextInt(ids.size() - r) + r);
                    cand.seek(r);
                    if (curr.nearest.doubleValue(cand) > 0.0) break;
                    if (metric && curr.second.doubleValue(cand) == 0.0) {
                        ++j;
                        continue block1;
                    }
                    if (!metric && !curr.medoids.contains(cand)) break;
                    if (r < 1000) continue;
                    throw new AbortException("Failed to choose a non-medoid in 1000 attempts. Choose k << N.");
                }
                if (!((cost = curr.computeCostDifferential(cand)) < -1.0E-12 * total)) {
                    ++j;
                    continue;
                }
                total += cost;
                curr.performLastSwap(cand);
                j = 1;
            }
            if (LOG.isStatistics()) {
                LOG.statistics(new DoubleStatistic(this.getClass().getName() + ".sample-" + i + ".cost", total));
            }
            if (total < bestscore) {
                Assignment tmp = curr;
                curr = best;
                best = tmp;
                bestscore = total;
            }
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        if (LOG.isStatistics()) {
            LOG.statistics(new DoubleStatistic(this.getClass().getName() + ".cost", bestscore));
        }
        ArrayModifiableDBIDs[] clusters = ClusteringAlgorithmUtil.partitionsFromIntegerLabels(ids, best.assignment, this.k);
        Clustering<MedoidModel> result = new Clustering<MedoidModel>("CLARANS Clustering", "clarans-clustering");
        DBIDArrayMIter it = best.medoids.iter();
        while (it.valid()) {
            result.addToplevelCluster(new Cluster<MedoidModel>((DBIDs)clusters[it.getOffset()], new MedoidModel(DBIDUtil.deref(it))));
            it.advance();
        }
        return result;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V>
    extends CLARANS.Parameterizer<V> {
        @Override
        protected double defaultRate() {
            return 2.0 * super.defaultRate();
        }

        @Override
        protected FastCLARANS<V> makeInstance() {
            return new FastCLARANS(this.distanceFunction, this.k, this.numlocal, this.maxneighbor, this.random);
        }
    }

    protected static class Assignment
    extends CLARANS.Assignment {
        double[] cost;
        protected int lastbest;

        public Assignment(DistanceQuery<?> distQ, DBIDs ids, int k) {
            super(distQ, ids, k);
            this.cost = new double[k];
        }

        protected double computeCostDifferential(DBIDRef h) {
            Arrays.fill(this.cost, 0.0);
            int k = this.cost.length;
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                if (!DBIDUtil.equal(h, j)) {
                    int jcur;
                    double distcur = this.nearest.doubleValue(j);
                    double dist_h = this.distQ.distance(h, (DBIDRef)j);
                    int n = jcur = this.assignment.intValue(j);
                    this.cost[n] = this.cost[n] + (Math.min(dist_h, this.second.doubleValue(j)) - distcur);
                    double change = dist_h - distcur;
                    if (change < 0.0) {
                        int mnum = 0;
                        while (mnum < jcur) {
                            int n2 = mnum++;
                            this.cost[n2] = this.cost[n2] + change;
                        }
                        mnum = jcur + 1;
                        while (mnum < k) {
                            int n3 = mnum++;
                            this.cost[n3] = this.cost[n3] + change;
                        }
                    }
                }
                j.advance();
            }
            double min = this.cost[0];
            this.lastbest = 0;
            for (int i = 1; i < k; ++i) {
                if (!(this.cost[i] < min)) continue;
                min = this.cost[i];
                this.lastbest = i;
            }
            return min;
        }

        protected void performLastSwap(DBIDRef h) {
            this.medoids.set(this.lastbest, h);
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                if (DBIDUtil.equal(h, j)) {
                    this.recompute(j, this.lastbest, 0.0, -1, Double.POSITIVE_INFINITY);
                } else {
                    double distcur = this.nearest.doubleValue(j);
                    double dist_h = this.distQ.distance(h, (DBIDRef)j);
                    int jcur = this.assignment.intValue(j);
                    if (jcur == this.lastbest) {
                        double distsec = this.second.doubleValue(j);
                        if (dist_h < distsec) {
                            this.assignment.putInt(j, this.lastbest);
                            this.nearest.putDouble(j, dist_h);
                            this.second.putDouble(j, distsec);
                            this.secondid.putInt(j, jcur);
                        } else {
                            this.recompute(j, this.lastbest, dist_h, jcur, distsec);
                        }
                    } else if (dist_h < distcur) {
                        this.assignment.putInt(j, this.lastbest);
                        this.nearest.putDouble(j, dist_h);
                        this.second.putDouble(j, distcur);
                        this.secondid.putInt(j, jcur);
                    } else {
                        int jsec = this.secondid.intValue(j);
                        double distsec = this.second.doubleValue(j);
                        if (jsec != this.lastbest && distsec <= dist_h) {
                            this.assignment.putInt(j, jcur);
                            this.nearest.putDouble(j, distcur);
                            this.secondid.putInt(j, jsec);
                            this.second.putDouble(j, distsec);
                        } else {
                            this.recompute(j, jcur, distcur, this.lastbest, dist_h);
                        }
                    }
                }
                j.advance();
            }
        }
    }
}

