/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeansHamerly;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.DoubleIntegerArrayQuickSort;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import java.util.Arrays;
import net.jafama.FastMath;

@References(value={@Reference(authors="J. Drake", title="Faster k-means clustering", booktitle="Faster k-means clustering", url="http://hdl.handle.net/2104/8826", bibkey="mathesis/Drake13"), @Reference(authors="G. Hamerly and J. Drake", title="Accelerating Lloyd\u2019s Algorithm for k-Means Clustering", booktitle="Partitional Clustering Algorithms", url="https://doi.org/10.1007/978-3-319-09259-1_2", bibkey="doi:10.1007/978-3-319-09259-1_2")})
public class KMeansAnnulus<V extends NumberVector>
extends KMeansHamerly<V> {
    private static final Logging LOG = Logging.getLogger(KMeansAnnulus.class);

    public KMeansAnnulus(NumberVectorDistanceFunction<? super V> distanceFunction, int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(distanceFunction, k, maxiter, initializer, varstat);
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        Instance instance = new Instance((Relation<? extends NumberVector>)relation, (NumberVectorDistanceFunction<?>)this.getDistanceFunction(), this.initialMeans(database, relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends KMeansHamerly.Parameterizer<V> {
        @Override
        protected KMeansAnnulus<V> makeInstance() {
            return new KMeansAnnulus(this.distanceFunction, this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends KMeansHamerly.Instance {
        WritableIntegerDataStore second;
        double[] cdist;
        int[] cnum;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistanceFunction<?> df, double[][] means) {
            super(relation, df, means);
            this.second = DataStoreUtil.makeIntegerStorage(relation.getDBIDs(), 3, -1);
            this.cdist = new double[this.k];
            this.cnum = new int[this.k];
        }

        @Override
        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                NumberVector fv = (NumberVector)this.relation.get(it);
                double min1 = Double.POSITIVE_INFINITY;
                double min2 = Double.POSITIVE_INFINITY;
                int minIndex = -1;
                int secIndex = -1;
                for (int i = 0; i < this.k; ++i) {
                    double dist = this.distance(fv, DoubleVector.wrap(this.means[i]));
                    if (dist < min1) {
                        secIndex = minIndex;
                        minIndex = i;
                        min2 = min1;
                        min1 = dist;
                        continue;
                    }
                    if (!(dist < min2)) continue;
                    secIndex = i;
                    min2 = dist;
                }
                ((ModifiableDBIDs)this.clusters.get(minIndex)).add(it);
                this.assignment.putInt(it, minIndex);
                this.second.putInt(it, secIndex);
                AbstractKMeans.plusEquals(this.sums[minIndex], fv);
                this.upper.putDouble(it, this.isSquared ? FastMath.sqrt(min1) : min1);
                this.lower.putDouble(it, this.isSquared ? FastMath.sqrt(min2) : min2);
                it.advance();
            }
            return this.relation.size();
        }

        protected void orderMeans() {
            int k = this.cdist.length;
            assert (this.sep.length == k);
            Arrays.fill(this.sep, Double.POSITIVE_INFINITY);
            for (int i = 0; i < k; ++i) {
                this.cdist[i] = VMath.euclideanLength(this.means[i]);
                this.cnum[i] = i;
                DoubleVector mi = DoubleVector.wrap(this.means[i]);
                for (int j = 0; j < i; ++j) {
                    double d = this.distance(mi, DoubleVector.wrap(this.means[j]));
                    d = 0.5 * (this.isSquared ? FastMath.sqrt(d) : d);
                    this.sep[i] = d < this.sep[i] ? d : this.sep[i];
                    this.sep[j] = d < this.sep[j] ? d : this.sep[j];
                }
            }
            DoubleIntegerArrayQuickSort.sort(this.cdist, this.cnum, k);
        }

        @Override
        protected int assignToNearestCluster() {
            assert (this.k == this.means.length);
            this.orderMeans();
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int cur = this.assignment.intValue(it);
                double z = this.lower.doubleValue(it);
                double sa = this.sep[cur];
                double u = this.upper.doubleValue(it);
                if (!(u <= z) && !(u <= sa)) {
                    NumberVector fv = (NumberVector)this.relation.get(it);
                    double curd2 = this.distance(fv, DoubleVector.wrap(this.means[cur]));
                    u = this.isSquared ? FastMath.sqrt(curd2) : curd2;
                    this.upper.putDouble(it, u);
                    if (!(u <= z) && !(u <= sa)) {
                        int sec = this.second.intValue(it);
                        double secd2 = this.distance(fv, DoubleVector.wrap(this.means[sec]));
                        double secd = this.isSquared ? FastMath.sqrt(secd2) : secd2;
                        double r = u > secd ? u : secd;
                        double norm = EuclideanDistanceFunction.STATIC.norm(fv);
                        double min1 = curd2;
                        double min2 = secd2;
                        int minIndex = cur;
                        int secIndex = sec;
                        if (curd2 > secd2) {
                            min1 = secd2;
                            min2 = curd2;
                            minIndex = sec;
                            secIndex = cur;
                        }
                        for (int i = 0; i < this.k; ++i) {
                            double d;
                            int c = this.cnum[i];
                            if (c == cur || c == sec || -(d = this.cdist[i] - norm) > r) continue;
                            if (d > r) break;
                            double dist = this.distance(fv, DoubleVector.wrap(this.means[c]));
                            if (dist < min1) {
                                secIndex = minIndex;
                                minIndex = c;
                                min2 = min1;
                                min1 = dist;
                                continue;
                            }
                            if (!(dist < min2)) continue;
                            secIndex = c;
                            min2 = dist;
                        }
                        if (minIndex != cur) {
                            ((ModifiableDBIDs)this.clusters.get(minIndex)).add(it);
                            ((ModifiableDBIDs)this.clusters.get(cur)).remove(it);
                            this.assignment.putInt(it, minIndex);
                            this.second.putInt(it, secIndex);
                            AbstractKMeans.plusMinusEquals(this.sums[minIndex], this.sums[cur], fv);
                            ++changed;
                            this.upper.putDouble(it, min1 == curd2 ? u : (this.isSquared ? FastMath.sqrt(min1) : min1));
                        }
                        this.lower.putDouble(it, min2 == curd2 ? u : (this.isSquared ? FastMath.sqrt(min2) : min2));
                    }
                }
                it.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

