/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.BestOfMultipleKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ProxyDatabase;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.LinkedList;

@Reference(authors="M. Steinbach, G. Karypis, V. Kumar", title="A Comparison of Document Clustering Techniques", booktitle="KDD workshop on text mining. Vol. 400. No. 1", url="http://glaros.dtc.umn.edu/gkhome/fetch/papers/docclusterKDDTMW00.pdf", bibkey="conf/kdd/SteinbachKK00")
public class KMeansBisecting<V extends NumberVector, M extends MeanModel>
extends AbstractAlgorithm<Clustering<M>>
implements KMeans<V, M> {
    private static final Logging LOG = Logging.getLogger(KMeansBisecting.class);
    private KMeans<V, M> innerkMeans;
    private int k;

    public KMeansBisecting(int k, KMeans<V, M> innerkMeans) {
        this.k = k;
        this.innerkMeans = innerkMeans;
    }

    @Override
    public Clustering<M> run(Database database, Relation<V> relation) {
        ProxyDatabase proxyDB = new ProxyDatabase(relation.getDBIDs(), database);
        LinkedList currentClusterList = new LinkedList();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Bisecting k-means", this.k - 1, LOG) : null;
        for (int j = 0; j < this.k - 1; ++j) {
            if (currentClusterList.isEmpty()) {
                proxyDB = new ProxyDatabase(relation.getDBIDs(), database);
            } else {
                Cluster largestCluster = null;
                for (Cluster cluster : currentClusterList) {
                    if (largestCluster != null && cluster.size() <= largestCluster.size()) continue;
                    largestCluster = cluster;
                }
                assert (largestCluster != null);
                currentClusterList.remove(largestCluster);
                proxyDB.setDBIDs(largestCluster.getIDs());
            }
            Result innerResult = this.innerkMeans.run(proxyDB);
            currentClusterList.addAll(((Clustering)innerResult).getAllClusters());
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        Clustering result = new Clustering("Bisecting k-Means Result", "Bisecting-k-means");
        for (Cluster cluster : currentClusterList) {
            result.addToplevelCluster(cluster);
        }
        return result;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.innerkMeans.getInputTypeRestriction();
    }

    @Override
    public DistanceFunction<? super V> getDistanceFunction() {
        return this.innerkMeans.getDistanceFunction();
    }

    @Override
    public void setK(int k) {
        this.k = k;
    }

    @Override
    public void setDistanceFunction(NumberVectorDistanceFunction<? super V> distanceFunction) {
        this.innerkMeans.setDistanceFunction(distanceFunction);
    }

    @Override
    public void setInitializer(KMeansInitialization init) {
        this.innerkMeans.setInitializer(init);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector, M extends MeanModel>
    extends AbstractParameterizer {
        public static final OptionID KMEANS_ID = new OptionID("bisecting.kmeansvariant", "KMeans variant");
        protected KMeans<V, M> kMeansVariant;
        protected int k;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter kMeansVariantP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(KMeans.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
            if (config.grab(kMeansVariantP = new ObjectParameter(KMEANS_ID, (Class<?>)KMeans.class, BestOfMultipleKMeans.class))) {
                ListParameterization kMeansVariantParameters = new ListParameterization();
                kMeansVariantParameters.addParameter(KMeans.K_ID, (Object)2);
                ChainedParameterization combinedConfig = new ChainedParameterization(kMeansVariantParameters, config);
                combinedConfig.errorsTo(config);
                this.kMeansVariant = (KMeans)kMeansVariantP.instantiateClass(combinedConfig);
            }
        }

        @Override
        protected KMeansBisecting<V, M> makeInstance() {
            return new KMeansBisecting<V, M>(this.k, this.kMeansVariant);
        }
    }
}

