/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.Arrays;

@Title(value="Compare-Means")
@Reference(authors="S. J. Phillips", title="Acceleration of k-means and related clustering algorithms", booktitle="Proc. 4th Int. Workshop on Algorithm Engineering and Experiments (ALENEX 2002)", url="https://doi.org/10.1007/3-540-45643-0_13", bibkey="DBLP:conf/alenex/Phillips02")
@Priority(value=199)
public class KMeansCompare<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(KMeansCompare.class);

    public KMeansCompare(NumberVectorDistanceFunction<? super V> distanceFunction, int k, int maxiter, KMeansInitialization initializer) {
        super(distanceFunction, k, maxiter, initializer);
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        Instance instance = new Instance((Relation<? extends NumberVector>)relation, (NumberVectorDistanceFunction<?>)this.getDistanceFunction(), this.initialMeans(database, relation));
        instance.run(this.maxiter);
        return instance.buildResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        @Override
        protected boolean needsMetric() {
            return true;
        }

        @Override
        protected KMeansCompare<V> makeInstance() {
            return new KMeansCompare(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        double[][] cdist;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistanceFunction<?> df, double[][] means) {
            super(relation, df, means);
            this.cdist = new double[this.k][this.k];
        }

        @Override
        protected int iterate(int iteration) {
            if (iteration > 1) {
                this.means = AbstractKMeans.means(this.clusters, this.means, this.relation);
            }
            this.recomputeSeperation(this.means, this.cdist);
            return this.assignToNearestCluster();
        }

        protected void recomputeSeperation(double[][] means, double[][] cdist) {
            int k = means.length;
            for (int i = 1; i < k; ++i) {
                DoubleVector mi = DoubleVector.wrap(means[i]);
                for (int j = 0; j < i; ++j) {
                    double d = this.distance(mi, DoubleVector.wrap(means[j]));
                    double d2 = 0.5 * d;
                    cdist[j][i] = d2;
                    cdist[i][j] = d2;
                }
            }
        }

        @Override
        protected int assignToNearestCluster() {
            int changed = 0;
            Arrays.fill(this.varsum, 0.0);
            for (ModifiableDBIDs cluster : this.clusters) {
                cluster.clear();
            }
            double mult = this.isSquared ? 4.0 : 2.0;
            DBIDIter iditer = this.relation.iterDBIDs();
            while (iditer.valid()) {
                int cur = this.assignment.intValue(iditer);
                int ini = cur >= 0 ? cur : 0;
                NumberVector fv = (NumberVector)this.relation.get(iditer);
                double mindist = this.distance(fv, DoubleVector.wrap(this.means[ini]));
                double threshold = mult * mindist;
                int minIndex = ini;
                for (int i = 0; i < this.k; ++i) {
                    double dist;
                    if (i == ini || this.cdist[minIndex][i] >= threshold || !((dist = this.distance(fv, DoubleVector.wrap(this.means[i]))) < mindist)) continue;
                    minIndex = i;
                    mindist = dist;
                }
                int n = minIndex;
                this.varsum[n] = this.varsum[n] + mindist;
                ((ModifiableDBIDs)this.clusters.get(minIndex)).add(iditer);
                if (this.assignment.putInt(iditer, minIndex) != minIndex) {
                    ++changed;
                }
                iditer.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

