/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeansSimplifiedElkan;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import net.jafama.FastMath;

@Reference(authors="C. Elkan", title="Using the triangle inequality to accelerate k-means", booktitle="Proc. 20th International Conference on Machine Learning, ICML 2003", url="http://www.aaai.org/Library/ICML/2003/icml03-022.php", bibkey="DBLP:conf/icml/Elkan03")
public class KMeansElkan<V extends NumberVector>
extends KMeansSimplifiedElkan<V> {
    private static final Logging LOG = Logging.getLogger(KMeansElkan.class);

    public KMeansElkan(NumberVectorDistanceFunction<? super V> distanceFunction, int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(distanceFunction, k, maxiter, initializer, varstat);
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        Instance instance = new Instance((Relation<? extends NumberVector>)relation, (NumberVectorDistanceFunction<?>)this.getDistanceFunction(), this.initialMeans(database, relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends KMeansSimplifiedElkan.Parameterizer<V> {
        @Override
        protected KMeansElkan<V> makeInstance() {
            return new KMeansElkan(this.distanceFunction, this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends KMeansSimplifiedElkan.Instance {
        double[][] cdist;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistanceFunction<?> df, double[][] means) {
            super(relation, df, means);
            this.cdist = new double[this.k][this.k];
            this.cdist = new double[this.k][this.k];
        }

        @Override
        protected int assignToNearestCluster() {
            assert (this.k == this.means.length);
            this.recomputeSeperation(this.sep, this.cdist);
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int orig = this.assignment.intValue(it);
                double u = this.upper.doubleValue(it);
                if (!(u <= this.sep[orig])) {
                    boolean recompute_u = true;
                    NumberVector fv = (NumberVector)this.relation.get(it);
                    double[] l = (double[])this.lower.get(it);
                    int cur = orig;
                    for (int j = 0; j < this.k; ++j) {
                        if (orig == j || u <= l[j] || u <= this.cdist[cur][j]) continue;
                        if (recompute_u) {
                            u = this.distance(fv, DoubleVector.wrap(this.means[cur]));
                            u = this.isSquared ? FastMath.sqrt(u) : u;
                            this.upper.putDouble(it, u);
                            recompute_u = false;
                            if (u <= l[j] || u <= this.cdist[cur][j]) continue;
                        }
                        double dist = this.distance(fv, DoubleVector.wrap(this.means[j]));
                        l[j] = dist = this.isSquared ? FastMath.sqrt(dist) : dist;
                        if (!(dist < u)) continue;
                        cur = j;
                        u = dist;
                    }
                    if (cur != orig) {
                        this.upper.putDouble(it, u);
                        ((ModifiableDBIDs)this.clusters.get(cur)).add(it);
                        ((ModifiableDBIDs)this.clusters.get(orig)).remove(it);
                        this.assignment.putInt(it, cur);
                        AbstractKMeans.plusMinusEquals(this.sums[cur], this.sums[orig], fv);
                        ++changed;
                    }
                }
                it.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

