/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeansHamerly;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import net.jafama.FastMath;

@Reference(authors="J. Newling", title="Fast k-means with accurate bounds", booktitle="Proc. 33nd Int. Conf. on Machine Learning, ICML 2016", url="http://jmlr.org/proceedings/papers/v48/newling16.html", bibkey="DBLP:conf/icml/NewlingF16")
public class KMeansExponion<V extends NumberVector>
extends KMeansHamerly<V> {
    private static final Logging LOG = Logging.getLogger(KMeansExponion.class);

    public KMeansExponion(NumberVectorDistanceFunction<? super V> distanceFunction, int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(distanceFunction, k, maxiter, initializer, varstat);
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        Instance instance = new Instance((Relation<? extends NumberVector>)relation, (NumberVectorDistanceFunction<?>)this.getDistanceFunction(), this.initialMeans(database, relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends KMeansHamerly.Parameterizer<V> {
        @Override
        protected KMeansExponion<V> makeInstance() {
            return new KMeansExponion(this.distanceFunction, this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends KMeansHamerly.Instance {
        WritableIntegerDataStore second;
        double[][] cdist;
        int[][] cnum;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistanceFunction<?> df, double[][] means) {
            super(relation, df, means);
            this.second = DataStoreUtil.makeIntegerStorage(relation.getDBIDs(), 3, -1);
            this.cdist = new double[this.k][this.k];
            this.cnum = new int[this.k][this.k - 1];
        }

        @Override
        protected int assignToNearestCluster() {
            assert (this.k == this.means.length);
            this.recomputeSeperation(this.sep, this.cdist);
            AbstractKMeans.nearestMeans(this.cdist, this.cnum);
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int cur = this.assignment.intValue(it);
                double z = this.lower.doubleValue(it);
                double sa = this.sep[cur];
                double u = this.upper.doubleValue(it);
                if (!(u <= z) && !(u <= sa)) {
                    NumberVector fv = (NumberVector)this.relation.get(it);
                    double curd2 = this.distance(fv, DoubleVector.wrap(this.means[cur]));
                    u = this.isSquared ? FastMath.sqrt(curd2) : curd2;
                    this.upper.putDouble(it, u);
                    if (!(u <= z) && !(u <= sa)) {
                        int c;
                        double r = u + 0.5 * sa;
                        double min1 = curd2;
                        double min2 = Double.POSITIVE_INFINITY;
                        int minIndex = cur;
                        for (int i = 0; i < this.k - 1 && !(this.cdist[cur][c = this.cnum[cur][i]] > r); ++i) {
                            double dist = this.distance(fv, DoubleVector.wrap(this.means[c]));
                            if (dist < min1) {
                                minIndex = c;
                                min2 = min1;
                                min1 = dist;
                                continue;
                            }
                            if (!(dist < min2)) continue;
                            min2 = dist;
                        }
                        if (minIndex != cur) {
                            ((ModifiableDBIDs)this.clusters.get(minIndex)).add(it);
                            ((ModifiableDBIDs)this.clusters.get(cur)).remove(it);
                            this.assignment.putInt(it, minIndex);
                            AbstractKMeans.plusMinusEquals(this.sums[minIndex], this.sums[cur], fv);
                            ++changed;
                            this.upper.putDouble(it, min1 == curd2 ? u : (this.isSquared ? FastMath.sqrt(min1) : min1));
                        }
                        this.lower.putDouble(it, min2 == curd2 ? u : (this.isSquared ? FastMath.sqrt(min2) : min2));
                    }
                }
                it.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

