/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.Arrays;
import net.jafama.FastMath;

@Reference(authors="G. Hamerly", title="Making k-means even faster", booktitle="Proc. 2010 SIAM International Conference on Data Mining", url="https://doi.org/10.1137/1.9781611972801.12", bibkey="DBLP:conf/sdm/Hamerly10")
public class KMeansHamerly<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(KMeansHamerly.class);
    protected boolean varstat = false;

    public KMeansHamerly(NumberVectorDistanceFunction<? super V> distanceFunction, int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(distanceFunction, k, maxiter, initializer);
        this.varstat = varstat;
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        Instance instance = new Instance((Relation<? extends NumberVector>)relation, (NumberVectorDistanceFunction<?>)this.getDistanceFunction(), this.initialMeans(database, relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        @Override
        protected boolean needsMetric() {
            return true;
        }

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            super.getParameterVarstat(config);
        }

        @Override
        protected KMeansHamerly<V> makeInstance() {
            return new KMeansHamerly(this.distanceFunction, this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        double[][] sums;
        double[][] newmeans;
        double[] sep;
        WritableDoubleDataStore upper;
        WritableDoubleDataStore lower;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistanceFunction<?> df, double[][] means) {
            super(relation, df, means);
            this.upper = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3, Double.POSITIVE_INFINITY);
            this.lower = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3, 0.0);
            int dim = means[0].length;
            this.sums = new double[this.k][dim];
            this.newmeans = new double[this.k][dim];
            this.sep = new double[this.k];
        }

        @Override
        protected int iterate(int iteration) {
            if (iteration == 1) {
                return this.initialAssignToNearestCluster();
            }
            this.meansFromSums(this.newmeans, this.sums);
            this.updateBounds(this.sep, this.movedDistance(this.means, this.newmeans, this.sep));
            this.copyMeans(this.newmeans, this.means);
            return this.assignToNearestCluster();
        }

        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                NumberVector fv = (NumberVector)this.relation.get(it);
                double min1 = Double.POSITIVE_INFINITY;
                double min2 = Double.POSITIVE_INFINITY;
                int minIndex = -1;
                for (int i = 0; i < this.k; ++i) {
                    double dist = this.distance(fv, DoubleVector.wrap(this.means[i]));
                    if (dist < min1) {
                        minIndex = i;
                        min2 = min1;
                        min1 = dist;
                        continue;
                    }
                    if (!(dist < min2)) continue;
                    min2 = dist;
                }
                ((ModifiableDBIDs)this.clusters.get(minIndex)).add(it);
                this.assignment.putInt(it, minIndex);
                AbstractKMeans.plusEquals(this.sums[minIndex], fv);
                this.upper.putDouble(it, this.isSquared ? FastMath.sqrt(min1) : min1);
                this.lower.putDouble(it, this.isSquared ? FastMath.sqrt(min2) : min2);
                it.advance();
            }
            return this.relation.size();
        }

        @Override
        protected int assignToNearestCluster() {
            assert (this.k == this.means.length);
            this.recomputeSeperation(this.means, this.sep);
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int cur = this.assignment.intValue(it);
                double z = this.lower.doubleValue(it);
                double sa = this.sep[cur];
                double u = this.upper.doubleValue(it);
                if (!(u <= z) && !(u <= sa)) {
                    NumberVector fv = (NumberVector)this.relation.get(it);
                    double curd2 = this.distance(fv, DoubleVector.wrap(this.means[cur]));
                    u = this.isSquared ? FastMath.sqrt(curd2) : curd2;
                    this.upper.putDouble(it, u);
                    if (!(u <= z) && !(u <= sa)) {
                        double min1 = curd2;
                        double min2 = Double.POSITIVE_INFINITY;
                        int minIndex = cur;
                        for (int i = 0; i < this.k; ++i) {
                            if (i == cur) continue;
                            double dist = this.distance(fv, DoubleVector.wrap(this.means[i]));
                            if (dist < min1) {
                                minIndex = i;
                                min2 = min1;
                                min1 = dist;
                                continue;
                            }
                            if (!(dist < min2)) continue;
                            min2 = dist;
                        }
                        if (minIndex != cur) {
                            ((ModifiableDBIDs)this.clusters.get(minIndex)).add(it);
                            ((ModifiableDBIDs)this.clusters.get(cur)).remove(it);
                            this.assignment.putInt(it, minIndex);
                            AbstractKMeans.plusMinusEquals(this.sums[minIndex], this.sums[cur], fv);
                            ++changed;
                            this.upper.putDouble(it, min1 == curd2 ? u : (this.isSquared ? FastMath.sqrt(min1) : min1));
                        }
                        this.lower.putDouble(it, min2 == curd2 ? u : (this.isSquared ? FastMath.sqrt(min2) : min2));
                    }
                }
                it.advance();
            }
            return changed;
        }

        protected void recomputeSeperation(double[][] means, double[] sep) {
            int k = means.length;
            assert (sep.length == k);
            Arrays.fill(sep, Double.POSITIVE_INFINITY);
            for (int i = 1; i < k; ++i) {
                DoubleVector m1 = DoubleVector.wrap(means[i]);
                for (int j = 0; j < i; ++j) {
                    double d = this.distance(m1, DoubleVector.wrap(means[j]));
                    sep[i] = d < sep[i] ? d : sep[i];
                    sep[j] = d < sep[j] ? d : sep[j];
                }
            }
            boolean issquared = this.isSquared();
            for (int i = 0; i < k; ++i) {
                sep[i] = 0.5 * (issquared ? FastMath.sqrt(sep[i]) : sep[i]);
            }
        }

        protected void updateBounds(double[] move, double delta) {
            delta = -delta;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                this.upper.increment(it, move[this.assignment.intValue(it)]);
                this.lower.increment(it, delta);
                it.advance();
            }
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

