/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="k-Means (Lloyd/Forgy Algorithm)")
@References(value={@Reference(authors="S. Lloyd", title="Least squares quantization in PCM", booktitle="IEEE Transactions on Information Theory 28 (2): 129\u2013137.", url="https://doi.org/10.1109/TIT.1982.1056489", bibkey="DBLP:journals/tit/Lloyd82"), @Reference(authors="E. W. Forgy", title="Cluster analysis of multivariate data: efficiency versus interpretability of classifications", booktitle="Biometrics 21(3)", bibkey="journals/biometrics/Forgy65")})
@Alias(value={"lloyd", "forgy", "de.lmu.ifi.dbs.elki.algorithm.clustering.KMeans", "de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans"})
public class KMeansLloyd<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(KMeansLloyd.class);

    public KMeansLloyd(NumberVectorDistanceFunction<? super V> distanceFunction, int k, int maxiter, KMeansInitialization initializer) {
        super(distanceFunction, k, maxiter, initializer);
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        Instance instance = new Instance((Relation<? extends NumberVector>)relation, (NumberVectorDistanceFunction<?>)this.getDistanceFunction(), this.initialMeans(database, relation));
        instance.run(this.maxiter);
        return instance.buildResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        @Override
        protected KMeansLloyd<V> makeInstance() {
            return new KMeansLloyd(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistanceFunction<?> df, double[][] means) {
            super(relation, df, means);
        }

        @Override
        protected int iterate(int iteration) {
            this.means = iteration == 1 ? this.means : AbstractKMeans.means(this.clusters, this.means, this.relation);
            return this.assignToNearestCluster();
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

