/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.Arrays;

@Title(value="k-Means (MacQueen Algorithm)")
@Reference(authors="J. MacQueen", title="Some Methods for Classification and Analysis of Multivariate Observations", booktitle="5th Berkeley Symp. Math. Statist. Prob.", url="http://projecteuclid.org/euclid.bsmsp/1200512992", bibkey="conf/bsmsp/MacQueen67")
public class KMeansMacQueen<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(KMeansMacQueen.class);

    public KMeansMacQueen(NumberVectorDistanceFunction<? super V> distanceFunction, int k, int maxiter, KMeansInitialization initializer) {
        super(distanceFunction, k, maxiter, initializer);
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        Instance instance = new Instance((Relation<? extends NumberVector>)relation, (NumberVectorDistanceFunction<?>)this.getDistanceFunction(), this.initialMeans(database, relation));
        instance.run(this.maxiter);
        return instance.buildResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        @Override
        protected KMeansMacQueen<V> makeInstance() {
            return new KMeansMacQueen(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistanceFunction<?> df, double[][] means) {
            super(relation, df, means);
        }

        @Override
        protected int iterate(int iteration) {
            int changed = 0;
            Arrays.fill(this.varsum, 0.0);
            DBIDIter iditer = this.relation.iterDBIDs();
            while (iditer.valid()) {
                double mindist = Double.POSITIVE_INFINITY;
                NumberVector fv = (NumberVector)this.relation.get(iditer);
                int minIndex = 0;
                for (int i = 0; i < this.k; ++i) {
                    double dist = this.distance(fv, DoubleVector.wrap(this.means[i]));
                    if (!(dist < mindist)) continue;
                    minIndex = i;
                    mindist = dist;
                }
                int n = minIndex;
                this.varsum[n] = this.varsum[n] + mindist;
                if (this.updateMeanAndAssignment(minIndex, fv, iditer)) {
                    ++changed;
                }
                iditer.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }

        private boolean updateMeanAndAssignment(int minIndex, NumberVector fv, DBIDIter iditer) {
            int cur = this.assignment.intValue(iditer);
            if (cur == minIndex) {
                return false;
            }
            ModifiableDBIDs curclus = (ModifiableDBIDs)this.clusters.get(minIndex);
            curclus.add(iditer);
            AbstractKMeans.incrementalUpdateMean(this.means[minIndex], fv, curclus.size(), 1.0);
            if (cur >= 0) {
                ModifiableDBIDs ci = (ModifiableDBIDs)this.clusters.get(cur);
                ci.remove(iditer);
                AbstractKMeans.incrementalUpdateMean(this.means[cur], fv, ci.size() + 1, -1.0);
            }
            this.assignment.putInt(iditer, minIndex);
            return true;
        }
    }
}

