/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import net.jafama.FastMath;

@Reference(authors="J. Newling", title="Fast k-means with accurate bounds", booktitle="Proc. 33nd Int. Conf. on Machine Learning, ICML 2016", url="http://jmlr.org/proceedings/papers/v48/newling16.html", bibkey="DBLP:conf/icml/NewlingF16")
public class KMeansSimplifiedElkan<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(KMeansSimplifiedElkan.class);
    protected boolean varstat = false;

    public KMeansSimplifiedElkan(NumberVectorDistanceFunction<? super V> distanceFunction, int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(distanceFunction, k, maxiter, initializer);
        this.varstat = varstat;
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        Instance instance = new Instance((Relation<? extends NumberVector>)relation, (NumberVectorDistanceFunction<?>)this.getDistanceFunction(), this.initialMeans(database, relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        @Override
        protected boolean needsMetric() {
            return true;
        }

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            super.getParameterVarstat(config);
        }

        @Override
        protected KMeansSimplifiedElkan<V> makeInstance() {
            return new KMeansSimplifiedElkan(this.distanceFunction, this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        WritableDoubleDataStore upper;
        WritableDataStore<double[]> lower;
        double[][] sums;
        double[][] newmeans;
        double[] sep;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistanceFunction<?> df, double[][] means) {
            super(relation, df, means);
            this.sep = new double[this.k];
            this.upper = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3, Double.POSITIVE_INFINITY);
            this.lower = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, double[].class);
            DBIDIter it = relation.iterDBIDs();
            while (it.valid()) {
                this.lower.put(it, new double[this.k]);
                it.advance();
            }
            int dim = means[0].length;
            this.sums = new double[this.k][dim];
            this.newmeans = new double[this.k][dim];
            this.sep = new double[this.k];
        }

        @Override
        protected int iterate(int iteration) {
            if (iteration == 1) {
                return this.initialAssignToNearestCluster();
            }
            this.meansFromSums(this.newmeans, this.sums);
            this.movedDistance(this.means, this.newmeans, this.sep);
            this.updateBounds(this.sep);
            this.copyMeans(this.newmeans, this.means);
            return this.assignToNearestCluster();
        }

        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                NumberVector fv = (NumberVector)this.relation.get(it);
                double[] l = (double[])this.lower.get(it);
                double best = Double.POSITIVE_INFINITY;
                int minIndex = -1;
                for (int j = 0; j < this.k; ++j) {
                    double dist = this.distance(fv, DoubleVector.wrap(this.means[j]));
                    l[j] = dist = this.isSquared ? FastMath.sqrt(dist) : dist;
                    if (!(dist < best)) continue;
                    minIndex = j;
                    best = dist;
                }
                ((ModifiableDBIDs)this.clusters.get(minIndex)).add(it);
                this.assignment.putInt(it, minIndex);
                this.upper.putDouble(it, best);
                AbstractKMeans.plusEquals(this.sums[minIndex], fv);
                it.advance();
            }
            return this.relation.size();
        }

        @Override
        protected int assignToNearestCluster() {
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int orig = this.assignment.intValue(it);
                double u = this.upper.doubleValue(it);
                boolean recompute_u = true;
                NumberVector fv = (NumberVector)this.relation.get(it);
                double[] l = (double[])this.lower.get(it);
                int cur = orig;
                for (int j = 0; j < this.k; ++j) {
                    if (orig == j || u <= l[j]) continue;
                    if (recompute_u) {
                        u = this.distance(fv, DoubleVector.wrap(this.means[cur]));
                        u = this.isSquared ? FastMath.sqrt(u) : u;
                        this.upper.putDouble(it, u);
                        recompute_u = false;
                        if (u <= l[j]) continue;
                    }
                    double dist = this.distance(fv, DoubleVector.wrap(this.means[j]));
                    l[j] = dist = this.isSquared ? FastMath.sqrt(dist) : dist;
                    if (!(dist < u)) continue;
                    cur = j;
                    u = dist;
                }
                if (cur != orig) {
                    this.upper.putDouble(it, u);
                    ((ModifiableDBIDs)this.clusters.get(cur)).add(it);
                    ((ModifiableDBIDs)this.clusters.get(orig)).remove(it);
                    this.assignment.putInt(it, cur);
                    AbstractKMeans.plusMinusEquals(this.sums[cur], this.sums[orig], fv);
                    ++changed;
                }
                it.advance();
            }
            return changed;
        }

        protected void updateBounds(double[] move) {
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                this.upper.increment(it, move[this.assignment.intValue(it)]);
                VMath.minusEquals((double[])this.lower.get(it), move);
                it.advance();
            }
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

