/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.QuickSelectDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.List;

@Reference(title="Clustering via Concave Minimization", authors="P. S. Bradley, O. L. Mangasarian, W. N. Street", booktitle="Advances in Neural Information Processing Systems", url="https://papers.nips.cc/paper/1260-clustering-via-concave-minimization", bibkey="DBLP:conf/nips/BradleyMS96")
public class KMediansLloyd<V extends NumberVector>
extends AbstractKMeans<V, MeanModel> {
    private static final Logging LOG = Logging.getLogger(KMediansLloyd.class);

    public KMediansLloyd(NumberVectorDistanceFunction<? super V> distanceFunction, int k, int maxiter, KMeansInitialization initializer) {
        super(distanceFunction, k, maxiter, initializer);
    }

    @Override
    public Clustering<MeanModel> run(Database database, Relation<V> relation) {
        Instance instance = new Instance((Relation<? extends NumberVector>)relation, (NumberVectorDistanceFunction<?>)this.getDistanceFunction(), this.initialMeans(database, relation));
        instance.run(this.maxiter);
        return instance.buildMediansResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        @Override
        protected KMediansLloyd<V> makeInstance() {
            return new KMediansLloyd(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistanceFunction<?> df, double[][] means) {
            super(relation, df, means);
        }

        @Override
        protected int iterate(int iteration) {
            if (iteration > 1) {
                this.means = this.medians(this.clusters, this.means, this.relation);
            }
            return this.assignToNearestCluster();
        }

        protected Clustering<MeanModel> buildMediansResult() {
            Clustering<MeanModel> result = new Clustering<MeanModel>("k-Medians Clustering", "kmedians-clustering");
            for (int i = 0; i < this.clusters.size(); ++i) {
                result.addToplevelCluster(new Cluster<MeanModel>((DBIDs)this.clusters.get(i), new MeanModel(this.means[i])));
            }
            return result;
        }

        protected double[][] medians(List<? extends DBIDs> clusters, double[][] medians, Relation<? extends NumberVector> relation) {
            int dim = medians[0].length;
            VectorUtil.SortDBIDsBySingleDimension sorter = new VectorUtil.SortDBIDsBySingleDimension(relation);
            double[][] newMedians = new double[this.k][];
            ArrayModifiableDBIDs list = DBIDUtil.newArray();
            DBIDArrayMIter it = list.iter();
            for (int i = 0; i < this.k; ++i) {
                DBIDs clu = clusters.get(i);
                if (clu.size() <= 0) {
                    newMedians[i] = medians[i];
                    continue;
                }
                list.clear();
                list.addDBIDs(clu);
                double[] mean = new double[dim];
                for (int d = 0; d < dim; ++d) {
                    sorter.setDimension(d);
                    mean[d] = relation.get(it.seek(QuickSelectDBIDs.median(list, sorter))).doubleValue(d);
                }
                newMedians[i] = mean;
            }
            return newMedians;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

